/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.rse.ui.view;

import java.util.List;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.rse.ui.view.System;
import org.eclipse.reddeer.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionPage;
import org.eclipse.reddeer.eclipse.test.rse.ui.view.SystemViewTestCase;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SystemViewTest
extends SystemViewTestCase {
    private static final String SYSTEM_A = "Test Remote System A";
    private static final String SYSTEM_B = "Test Remote System B";

    @Test
    public void newConnection() {
        this.wizardDialog = this.remoteSystemView.newConnection();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)"New Connection"));
    }

    @Test
    public void getSystems_noRemoteSystem() {
        List systems = this.remoteSystemView.getSystems();
        Assert.assertThat((Object)systems.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void getSystems() {
        this.createSystem("localhost", SYSTEM_A, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        this.createSystem("127.0.0.1", SYSTEM_B, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        List systems = this.remoteSystemView.getSystems();
        Assert.assertThat((Object)systems.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((System)systems.get(1)).getLabel(), (Matcher)CoreMatchers.is((Object)SYSTEM_A));
        Assert.assertThat((Object)((System)systems.get(2)).getLabel(), (Matcher)CoreMatchers.is((Object)SYSTEM_B));
    }

    @Test(expected=EclipseLayerException.class)
    public void getSystem_noRemoteSystem() {
        this.remoteSystemView.getSystem("NO Remote System");
    }

    @Test(expected=EclipseLayerException.class)
    public void getSystem_notFound() {
        this.createSystem("127.0.0.1", SYSTEM_A, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        this.remoteSystemView.getSystem("No Remote System");
    }

    @Test
    public void getSystem() {
        this.createSystem("localhost", SYSTEM_A, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        this.createSystem("127.0.0.1", SYSTEM_B, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        System system = this.remoteSystemView.getSystem(SYSTEM_A);
        Assert.assertNotNull((Object)system);
        Assert.assertThat((Object)system.getLabel(), (Matcher)CoreMatchers.is((Object)SYSTEM_A));
    }
}

