/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.selectionwizard;

import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.direct.preferences.PreferencesUtil;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.handler.WorkbenchShellHandler;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class NewMenuWizardTest {
    private PackageExplorerPart packageExplorer;
    private String projectName = "webProject";

    @BeforeClass
    public static void setUpPreferences() {
        PreferencesUtil.setOpenAssociatedPerspective((String)"prompt");
    }

    @Before
    public void prepareWorkspace() {
        this.packageExplorer = new PackageExplorerPart();
        this.packageExplorer.open();
        JavaPerspective perspective = new JavaPerspective();
        perspective.open();
    }

    @After
    public void deleteProject() {
        WorkbenchShellHandler.getInstance().closeAllNonWorbenchShells();
        this.packageExplorer.close();
        this.packageExplorer.open();
        this.packageExplorer.deleteAllProjects(true);
    }

    @AfterClass
    public static void cleanUpPreferences() {
        PreferencesUtil.setOpenAssociatedPerspective((String)"never");
    }

    @Test
    public void openPerspective() {
        this.createProjectAndOpenPerspective(this.projectName, true);
        Assert.assertTrue((boolean)this.checkPerspective().equals("Java EE"));
    }

    @Test
    public void doNotOpenPerspective() {
        this.createProjectAndOpenPerspective(this.projectName, false);
        Assert.assertTrue((boolean)this.checkPerspective().equals("Java"));
    }

    @Test(expected=RedDeerException.class)
    public void testThrowException() {
        PreferencesUtil.setOpenAssociatedPerspective((String)"never");
        this.createProjectAndOpenPerspective(this.projectName, false);
    }

    private void createProjectAndOpenPerspective(String projectName, boolean openPerspective) {
        WebProjectWizard ww = new WebProjectWizard();
        ww.open();
        WebProjectFirstPage fp = new WebProjectFirstPage((WizardDialog)ww);
        fp.setProjectName(projectName);
        ww.finish(openPerspective);
    }

    private String checkPerspective() {
        String activePerspectiveLabel = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getLabel();
            }
        });
        return activePerspectiveLabel;
    }
}

