/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.dialogs;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.test.ui.dialogs.TestPropertyPage;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyDialog;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ExplorerItemPropertyDialogTest {
    private static final String PROJECT_NAME = "Property test project";
    private static DefaultProject project;
    private PropertyDialog dialog;
    private PropertyPage page;

    @BeforeClass
    public static void createProject() {
        JavaProjectWizard wizardDialog = new JavaProjectWizard();
        wizardDialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)wizardDialog);
        page1.setProjectName(PROJECT_NAME);
        wizardDialog.finish();
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        project = explorer.getProject(PROJECT_NAME);
    }

    @Before
    public void setup() {
        this.dialog = project.openProperties();
        this.page = new TestPropertyPageRedDeer(this.dialog);
    }

    @After
    public void cleanup() {
        if (this.dialog != null && this.dialog.isOpen()) {
            this.dialog.cancel();
        }
    }

    @AfterClass
    public static void deleteProject() {
        DeleteUtils.forceProjectDeletion((DefaultProject)project, (boolean)true);
    }

    @Test
    public void openAndSelect() {
        this.dialog.open();
        DefaultShell shell = new DefaultShell();
        MatcherAssert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)this.dialog.getShell().getText()));
        this.dialog.select((PreferencePage)this.page);
        MatcherAssert.assertThat((Object)this.dialog.getPageName(), (Matcher)CoreMatchers.is((Object)"Property page test"));
    }

    @Test
    public void openAndSelectByPath() {
        this.dialog.open();
        DefaultShell shell = new DefaultShell();
        MatcherAssert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)this.dialog.getShell().getText()));
        this.dialog.select(new String[]{"Property page test"});
        MatcherAssert.assertThat((Object)this.dialog.getPageName(), (Matcher)CoreMatchers.is((Object)"Property page test"));
    }

    @Test
    public void ok() {
        this.dialog.open();
        this.dialog.select((PreferencePage)this.page);
        String dialogText = this.dialog.getShell().getText();
        this.dialog.ok();
        DefaultShell shell = new DefaultShell();
        MatcherAssert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)dialogText)));
        Assert.assertTrue((boolean)TestPropertyPage.performOkCalled);
    }

    @Test
    public void cancel() {
        this.dialog.open();
        this.dialog.select((PreferencePage)this.page);
        String dialogText = this.dialog.getShell().getText();
        this.dialog.cancel();
        DefaultShell shell = new DefaultShell();
        MatcherAssert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)dialogText)));
        Assert.assertTrue((boolean)TestPropertyPage.performCancelCalled);
    }

    @Test
    public void apply() {
        this.dialog.open();
        this.dialog.select((PreferencePage)this.page);
        this.page.apply();
        DefaultShell shell = new DefaultShell();
        MatcherAssert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)this.dialog.getShell().getText()));
        MatcherAssert.assertThat((Object)this.page.getName(), (Matcher)CoreMatchers.is((Object)"Property page test"));
        Assert.assertTrue((boolean)TestPropertyPage.performApplyCalled);
    }

    @Test
    public void restoreDefaults() {
        this.dialog.open();
        this.dialog.select((PreferencePage)this.page);
        this.page.restoreDefaults();
        DefaultShell shell = new DefaultShell();
        MatcherAssert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)this.dialog.getShell().getText()));
        MatcherAssert.assertThat((Object)this.page.getName(), (Matcher)CoreMatchers.is((Object)"Property page test"));
        Assert.assertTrue((boolean)TestPropertyPage.performDefaultsCalled);
    }

    private class TestPropertyPageRedDeer
    extends PropertyPage {
        public TestPropertyPageRedDeer(PropertyDialog dialog) {
            super((ReferencedComposite)dialog, new String[]{"Property page test"});
        }
    }
}

