/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.problems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ExactNumberOfProblemsExists;
import org.eclipse.reddeer.eclipse.condition.ProblemExists;
import org.eclipse.reddeer.eclipse.condition.ProblemsViewIsEmpty;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.AbstractMarkerMatcher;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.MarkerDescriptionMatcher;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.MarkerLocationMatcher;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.MarkerPathMatcher;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.MarkerResourceMatcher;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.MarkerTypeMatcher;
import org.eclipse.reddeer.eclipse.ui.problems.Problem;
import org.eclipse.reddeer.eclipse.ui.views.markers.AbstractMarkersSupportView;
import org.eclipse.reddeer.eclipse.ui.views.markers.ProblemsView;
import org.eclipse.reddeer.eclipse.ui.views.markers.QuickFixPage;
import org.eclipse.reddeer.eclipse.ui.views.markers.QuickFixWizard;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringStartsWith;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@CleanWorkspaceRequirement.CleanWorkspace
public class ProblemsViewTest {
    private PackageExplorerPart pkgExplorer;
    private ProblemsView problemsView;
    private static final String JAVA_PROBLEM = "Java Problem";
    private static final String PROJECT_NAME = "ProblemsViewTestProject";
    private static final String DEFAULT_ERROR_CLASS_NAME = "ErrorTestClass";
    private static final String ERROR_DESCRIPTION = "Syntax error on token \"testError\", delete this token";
    private static final String ERROR_LOCATION = "line 1";
    private static final String DEFAULT_WARNING_CLASS_NAME = "WarningTestClass";
    private static final String WARNING_LOCATION = "line 2";

    @Before
    public void setUp() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME);
        dialog.finish();
        this.problemsView = new ProblemsView();
        this.problemsView.open();
        this.pkgExplorer = new PackageExplorerPart();
        this.pkgExplorer.open();
    }

    @After
    public void tearDown() {
        this.problemsView.showDefaultProblemColumns();
        this.pkgExplorer.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)this.pkgExplorer.getProject(PROJECT_NAME), (boolean)true);
    }

    @Test
    public void testShowProblemColumns() {
        this.problemsView.showDefaultProblemColumns();
        Assert.assertFalse((String)"ID column should not be shown at this point, but it is.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.ID.toString()));
        Assert.assertFalse((String)"Creation Time column should not be shown at this point, but it is.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.CREATION_TIME.toString()));
        this.problemsView.showProblemColumns(new AbstractMarkersSupportView.Column[]{AbstractMarkersSupportView.Column.ID, AbstractMarkersSupportView.Column.CREATION_TIME, AbstractMarkersSupportView.Column.DESCRIPTION});
        Assert.assertTrue((String)"ID column should be shown at this point, but it is not.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.ID.toString()));
        Assert.assertTrue((String)"Creation Time column should be shown at this point, but it is not.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.CREATION_TIME.toString()));
    }

    @Test
    public void testHideProblemColumns() {
        this.problemsView.showDefaultProblemColumns();
        Assert.assertTrue((String)"Resource problem column should be shown at this point, but it is not", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.RESOURCE.toString()));
        this.problemsView.hideProblemColumn(new AbstractMarkersSupportView.Column[]{AbstractMarkersSupportView.Column.RESOURCE, AbstractMarkersSupportView.Column.LOCATION, AbstractMarkersSupportView.Column.ID});
        Assert.assertFalse((String)"Resource problem column should be hidden at this point, but it is not.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.RESOURCE.toString()));
        Assert.assertFalse((String)"Location problem column should be hidden at this point, but it is not.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.LOCATION.toString()));
    }

    @Test
    public void testShowProblemColumnNullArgument() {
        this.problemsView.showProblemColumns(null);
    }

    @Test
    public void testShowProblemColumnEmptyArrayArgument() {
        this.problemsView.showProblemColumns(new AbstractMarkersSupportView.Column[0]);
    }

    @Test
    public void testShowVisibleProblemColumn() {
        this.problemsView.showDefaultProblemColumns();
        this.problemsView.showProblemColumns(new AbstractMarkersSupportView.Column[]{AbstractMarkersSupportView.Column.DESCRIPTION});
        Assert.assertTrue((String)"Description problem column should be visible, but it is not.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.DESCRIPTION.toString()));
    }

    @Test
    public void testHideProblemColumnsNullArgument() {
        this.problemsView.hideProblemColumn(null);
    }

    @Test
    public void testHideProblemColumnsEmptyArrayArgument() {
        this.problemsView.hideProblemColumn(new AbstractMarkersSupportView.Column[0]);
    }

    @Test
    public void testHideHiddenProblemColumn() {
        this.problemsView.showDefaultProblemColumns();
        this.problemsView.hideProblemColumn(new AbstractMarkersSupportView.Column[]{AbstractMarkersSupportView.Column.ID});
        Assert.assertFalse((String)"ID problem column should not be visible, but it is.", (boolean)this.problemsView.getProblemColumns().contains(AbstractMarkersSupportView.Column.ID.toString()));
    }

    @Test
    public void testGetProblemColumns() {
        this.pkgExplorer.open();
        this.createError();
        List foundColumns = this.problemsView.getProblemColumns();
        ArrayList<String> requiredColumns = new ArrayList<String>(Arrays.asList("Description", "Resource", "Path", "Location", "Type"));
        Assert.assertTrue((String)("Number of retrieved columns should be " + requiredColumns.size() + " but there were found " + foundColumns.size() + " columns."), (foundColumns.size() == requiredColumns.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < foundColumns.size()) {
            Assert.assertTrue((String)("Found columns was " + (String)foundColumns.get(i) + " but should be " + (String)requiredColumns.get(i)), (boolean)((String)foundColumns.get(i)).equals(requiredColumns.get(i)));
            ++i;
        }
    }

    @Test
    public void testNoErrorNoWarning() {
        this.problemsView.open();
        new WaitUntil((WaitCondition)new ProblemsViewIsEmpty(), TimePeriod.DEFAULT);
        Assert.assertTrue((String)("Errors node should be empty, but:\n" + this.getProblems()), (boolean)this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]).isEmpty());
        Assert.assertTrue((String)("Warnings node should be empty, but:\n" + this.getProblems()), (boolean)this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]).isEmpty());
    }

    @Test
    public void testOneErrorNoWarning() {
        this.createError();
        new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        new WaitWhile((WaitCondition)new ProblemExists(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        Assert.assertEquals((String)("Errors node should contain one error, but:\n" + this.getProblems()), (long)1L, (long)this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]).size());
        Assert.assertTrue((String)("Warnings node should be empty, but:\n" + this.getProblems()), (boolean)this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]).isEmpty());
    }

    @Test
    public void testNoErrorOneWarning() {
        this.createWarning();
        new WaitWhile((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        Assert.assertTrue((String)("Errors node should be empty, but:\n" + this.getProblems()), (boolean)this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]).isEmpty());
        Assert.assertEquals((String)("Warnings node should contain one warning, but:\n" + this.getProblems()), (long)1L, (long)this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]).size());
    }

    @Test
    public void testOneErrorOneWarning() {
        this.createError();
        this.createWarning();
        new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        Assert.assertEquals((String)("Errors node should contain one error, but:\n" + this.getProblems()), (long)1L, (long)this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]).size());
        Assert.assertEquals((String)("Warnings node should contain one warning, but:\n" + this.getProblems()), (long)1L, (long)this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]).size());
    }

    @Test
    public void testOneErrorExists() {
        this.createError();
        try {
            new WaitUntil((WaitCondition)new ExactNumberOfProblemsExists(ProblemsView.ProblemType.ERROR, 1), TimePeriod.DEFAULT);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)("Wait condition exact number of problems exists did not pass altough it should. There is following amount of errors: " + this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]) + " altough there should be precisely 1 error."));
        }
    }

    @Test
    public void testOneWarningExists() {
        this.createWarning();
        try {
            new WaitUntil((WaitCondition)new ExactNumberOfProblemsExists(ProblemsView.ProblemType.WARNING, 1), TimePeriod.DEFAULT);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)("Wait condition exact number of problems exists did not pass altough it should. There is following amount of warnings: " + this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]) + " altough there should be precisely 1 warning."));
        }
    }

    @Test
    public void testTwoProblemsExist() {
        this.createWarning();
        this.createError();
        try {
            new WaitUntil((WaitCondition)new ExactNumberOfProblemsExists(ProblemsView.ProblemType.ALL, 2), TimePeriod.DEFAULT);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)("Wait condition exact number of problems exists did not pass altough it should. There is following amount of problems: " + this.problemsView.getProblems(ProblemsView.ProblemType.ALL, new AbstractMarkerMatcher[0]) + " altough there should be precisely 2 problems"));
        }
    }

    @Test
    public void testFilterErrors() {
        this.createError();
        this.createProblem(true, "NextErrorTestClass");
        this.createWarning();
        new GroupWait(new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0])), WaitProvider.waitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]))});
        List errors = new ProblemsView().getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[]{new MarkerDescriptionMatcher(Is.is((Object)ERROR_DESCRIPTION)), new MarkerResourceMatcher("ErrorTestClass.java"), new MarkerPathMatcher(StringStartsWith.startsWith((String)"/ProblemsViewTestProject/src")), new MarkerLocationMatcher(Is.is((Object)ERROR_LOCATION)), new MarkerTypeMatcher(Is.is((Object)JAVA_PROBLEM))});
        Assert.assertEquals((long)1L, (long)errors.size());
        Problem error = (Problem)errors.get(0);
        Assert.assertEquals((String)"Error description", (Object)ERROR_DESCRIPTION, (Object)error.getDescription());
        Assert.assertEquals((String)"Error resource", (Object)"ErrorTestClass.java", (Object)error.getResource());
        Assert.assertEquals((String)"Error path", (Object)"/ProblemsViewTestProject/src", (Object)error.getPath());
        Assert.assertEquals((String)"Error location", (Object)ERROR_LOCATION, (Object)error.getLocation());
        Assert.assertEquals((String)"Error type", (Object)JAVA_PROBLEM, (Object)error.getType());
        errors = this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[]{new MarkerDescriptionMatcher(Is.is((Object)ERROR_DESCRIPTION)), new MarkerTypeMatcher(Is.is((Object)JAVA_PROBLEM))});
        Assert.assertEquals((String)("Errors node should contain two Java Problem errors with description equal to \"Syntax error on token \"testError\", delete this token\", but:\n" + this.getProblems()), (long)2L, (long)errors.size());
    }

    @Test
    public void testFilterWarnings() {
        this.createWarning();
        this.createProblem(false, "NextWarningTestClass");
        this.createError();
        new GroupWait(new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0])), WaitProvider.waitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]))});
        List warnings = new ProblemsView().getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[]{new MarkerDescriptionMatcher(Is.is((Object)"The value of the field WarningTestClass.i is not used")), new MarkerResourceMatcher(Is.is((Object)"WarningTestClass.java")), new MarkerPathMatcher(StringStartsWith.startsWith((String)"/ProblemsViewTestProject/src")), new MarkerLocationMatcher(Is.is((Object)WARNING_LOCATION)), new MarkerTypeMatcher(Is.is((Object)JAVA_PROBLEM))});
        Assert.assertEquals((long)1L, (long)warnings.size());
        Problem warning = (Problem)warnings.get(0);
        Assert.assertEquals((String)"Warning description", (Object)"The value of the field WarningTestClass.i is not used", (Object)warning.getDescription());
        Assert.assertEquals((String)"Warning resource", (Object)"WarningTestClass.java", (Object)warning.getResource());
        Assert.assertEquals((String)"Warning path", (Object)"/ProblemsViewTestProject/src", (Object)warning.getPath());
        Assert.assertEquals((String)"Warning location", (Object)WARNING_LOCATION, (Object)warning.getLocation());
        Assert.assertEquals((String)"Warning type", (Object)JAVA_PROBLEM, (Object)warning.getType());
        warnings = this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[]{new MarkerPathMatcher(StringStartsWith.startsWith((String)"/ProblemsViewTestProject/src")), new MarkerLocationMatcher(Is.is((Object)WARNING_LOCATION))});
        Assert.assertEquals((String)("Warnings node should contain two Java Problem warnings in the location \"line 2\" of the project with path \"/ProblemsViewTestProject/src\", but:\n" + this.getProblems()), (long)2L, (long)warnings.size());
    }

    @Test
    public void testProblemQuickfix() {
        this.createWarning();
        QuickFixWizard qw = ((Problem)new ProblemsView().getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]).get(0)).openQuickFix();
        QuickFixPage qp = new QuickFixPage((ReferencedComposite)qw);
        List problems = qp.getAvailableFixes();
        Assert.assertTrue((problems.size() == 4 ? 1 : 0) != 0);
        qp.selectFix("Add @SuppressWarnings 'unused' to 'i'");
        qw.finish();
        TextEditor te = new TextEditor("WarningTestClass.java");
        Assert.assertTrue((boolean)te.getText().contains("@SuppressWarnings(\"unused\")"));
    }

    @Test
    public void testProblemQuickfixWithNewDialog() {
        this.pkgExplorer.open();
        this.pkgExplorer.getProject(PROJECT_NAME).getProjectItem(new String[]{"src"}).select();
        NewClassCreationWizard newJavaClassDialog = new NewClassCreationWizard();
        newJavaClassDialog.open();
        NewClassWizardPage wizardPage = new NewClassWizardPage((ReferencedComposite)newJavaClassDialog);
        wizardPage.setName("NonExistingImportQuickFix");
        newJavaClassDialog.finish();
        TextEditor textEditor = new TextEditor("NonExistingImportQuickFix.java");
        textEditor.insertLine(1, "import abc.efg.SomeClass;");
        textEditor.save();
        new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]));
        QuickFixWizard qw = ((Problem)new ProblemsView().getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]).get(0)).openQuickFix();
        QuickFixPage qp = new QuickFixPage((ReferencedComposite)qw);
        qp.selectFix("Create class 'SomeClass' in package 'abc.efg'");
        qw.finish();
        DefaultShell newShell = new DefaultShell("New");
        new FinishButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)newShell));
        new TextEditor("SomeClass.java");
    }

    private void createError() {
        this.createProblem(true);
    }

    private void createWarning() {
        this.createProblem(false);
    }

    private void createProblem(boolean error, String newClassName) {
        this.pkgExplorer.open();
        this.pkgExplorer.getProject(PROJECT_NAME).getProjectItem(new String[]{"src"}).select();
        NewClassCreationWizard newJavaClassDialog = new NewClassCreationWizard();
        newJavaClassDialog.open();
        NewClassWizardPage wizardPage = new NewClassWizardPage((ReferencedComposite)newJavaClassDialog);
        wizardPage.setName(newClassName);
        newJavaClassDialog.finish();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        StringBuilder sbJavaCode = new StringBuilder("");
        if (error) {
            sbJavaCode.append("testError\n");
            sbJavaCode.append("public class ");
            sbJavaCode.append(newClassName);
            sbJavaCode.append("{\n");
            sbJavaCode.append("}\n");
        } else {
            sbJavaCode.append("public class ");
            sbJavaCode.append(newClassName);
            sbJavaCode.append("{\n");
            sbJavaCode.append("  private int i;\n");
            sbJavaCode.append("}\n");
        }
        TextEditor textEditor = new TextEditor(String.valueOf(newClassName) + ".java");
        textEditor.setText(sbJavaCode.toString());
        textEditor.save();
        this.problemsView.open();
        if (error) {
            new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        } else {
            new WaitUntil((WaitCondition)new ProblemExists(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0]), TimePeriod.DEFAULT);
        }
    }

    private void createProblem(boolean error) {
        this.createProblem(error, error ? DEFAULT_ERROR_CLASS_NAME : DEFAULT_WARNING_CLASS_NAME);
    }

    private String getProblems() {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors:\n");
        for (Problem problem : this.problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[0])) {
            builder.append("\t");
            builder.append(problem);
            builder.append("\n");
        }
        builder.append("Warnings:\n");
        for (Problem problem : this.problemsView.getProblems(ProblemsView.ProblemType.WARNING, new AbstractMarkerMatcher[0])) {
            builder.append("\t");
            builder.append(problem);
            builder.append("\n");
        }
        return builder.toString();
    }
}

