/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.views.properties;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheetProperty;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class PropertiesViewTest {
    private static final String TEST_PROJECT_NAME = "PropertiesViewTestProject";

    @Before
    public void setUp() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(TEST_PROJECT_NAME);
        dialog.finish();
        new PackageExplorerPart().getProject(TEST_PROJECT_NAME).getTreeItem().select();
    }

    @Test
    public void getProperty() {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        propertiesView.toggleShowCategories(true);
        String namePropertyValue = propertiesView.getProperty(new String[]{"Info", "name"}).getPropertyValue();
        Assert.assertTrue((String)("name property has to have value PropertiesViewTestProject but is " + namePropertyValue), (boolean)namePropertyValue.equals(TEST_PROJECT_NAME));
    }

    @Test
    public void getProperties() {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        propertiesView.toggleShowCategories(true);
        List properties = propertiesView.getProperties();
        Assert.assertTrue((String)("Expected cound of properties was 8 but is" + properties.size()), (properties.size() == 8 ? 1 : 0) != 0);
        LinkedList<String> propNames = new LinkedList<String>();
        for (PropertySheetProperty prop : properties) {
            propNames.add(prop.getPropertyName());
        }
        String propName = "name";
        Assert.assertTrue((String)("Properties list doesn't contain property " + propName), (boolean)propNames.contains(propName));
        propName = "location";
        Assert.assertTrue((String)("Properties list doesn't contain property " + propName), (boolean)propNames.contains(propName));
    }

    @Test(expected=CoreLayerException.class)
    public void getNonExistingProperty() {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.getProperty(new String[]{"@#$_NON_EXISTING_PROPERTY_%^$"});
    }

    @Test
    public void toggleShowCategories() {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        propertiesView.toggleShowCategories(true);
        Assert.assertTrue((String)"Properties view has to contain property Info", (boolean)this.containsProperty(propertiesView, "Info"));
        propertiesView.toggleShowCategories(false);
        Assert.assertFalse((String)"Properties view cannot to contain property Info", (boolean)this.containsProperty(propertiesView, "Info"));
    }

    @After
    public void tearDown() {
        PackageExplorerPart packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        if (packageExplorer.containsProject(TEST_PROJECT_NAME)) {
            DeleteUtils.forceProjectDeletion((DefaultProject)packageExplorer.getProject(TEST_PROJECT_NAME), (boolean)true);
        }
    }

    private boolean containsProperty(PropertySheet propertiesView, String ... propertyNamePath) {
        boolean result = false;
        try {
            propertiesView.getProperty(propertyNamePath);
            result = true;
        }
        catch (CoreLayerException coreLayerException) {
            result = false;
        }
        return result;
    }
}

