/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.requirement.configuration;

import org.eclipse.reddeer.junit.requirement.RequirementException;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.ComplexConfiguration;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.SimpleConfiguration;
import org.eclipse.reddeer.junit.util.ReflectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequirementConfigurationTest {
    private SimpleConfiguration simpleConfig;
    private ComplexConfiguration complexConfig;
    private SimpleConfiguration simpleConfig2;
    private String version1 = "version1";
    private String name1 = "name1";
    private String type1 = "type1";
    private String version2 = "version2";
    private String name2 = "name2";
    private String type2 = "type2";
    private String cname = "cname";
    private String ctype = "ctype";
    private String cversion = "cversion";

    @Before
    public void setup() {
        this.simpleConfig = new SimpleConfiguration();
        this.simpleConfig.setName(this.name1);
        this.simpleConfig.setType(this.type1);
        this.simpleConfig.setVersion(this.version1);
        this.simpleConfig2 = new SimpleConfiguration();
        this.simpleConfig2.setName(this.name2);
        this.simpleConfig2.setType(this.type2);
        this.simpleConfig2.setVersion(this.version2);
        this.complexConfig = new ComplexConfiguration();
        this.complexConfig.setComplexName(this.cname);
        this.complexConfig.setComplexType(this.ctype);
        this.complexConfig.setComplexVersion(this.cversion);
        this.complexConfig.setSimpleConfiguration(this.simpleConfig2);
    }

    @Test
    public void testGetStringAttribute() {
        Assert.assertTrue((boolean)ReflectionUtil.getValue((Object)this.simpleConfig, (String)"version").equals(this.version1));
        Assert.assertTrue((boolean)ReflectionUtil.getValue((Object)this.simpleConfig, (String)"name").equals(this.name1));
        Assert.assertTrue((boolean)ReflectionUtil.getValue((Object)this.simpleConfig, (String)"type").equals(this.type1));
    }

    @Test
    public void testGetObjectAttribute() {
        SimpleConfiguration config = (SimpleConfiguration)ReflectionUtil.getValue((Object)this.complexConfig, (String)"simpleConfiguration");
        Assert.assertTrue((boolean)config.getName().equals(this.name2));
        Assert.assertTrue((boolean)config.getVersion().equals(this.version2));
        Assert.assertTrue((boolean)config.getType().equals(this.type2));
    }

    @Test
    public void testGetStringObjectAttributeInPlaceOfSimpleAttribute() {
        ReflectionUtil.getValue((Object)this.simpleConfig, (String)"name");
    }

    @Test(expected=RequirementException.class)
    public void testGetAttributeOfComplexConfiguration() {
        ReflectionUtil.getValue((Object)this.complexConfig, (String)"name");
    }

    @Test(expected=RequirementException.class)
    public void getNonexistingStringAttribute() {
        ReflectionUtil.getValue((Object)this.simpleConfig, (String)"idontexist");
    }

    @Test(expected=RequirementException.class)
    public void testGetNonexistingObjectAttribute() {
        ReflectionUtil.getValue((Object)this.simpleConfig, (String)"simpleConfiguration");
    }
}

