/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.rules;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.reddeer.junit.rules.ErrorCollectorWithScreenshot;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ErrorCollectorWithScreenshotTest {
    @Rule
    public ErrorCollectorWithScreenshot errorCollector = new ErrorCollectorWithScreenshot();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    @After
    public void deleteScreenshots() {
        File[] files = this.getFiles(this.errorCollector.getScreenshotDirPath(), ".*failAtTheEndTest.*\\.png|.*screenshotCapturerTest.*\\.png");
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Test
    public void failAtTheEndTest() {
        this.errorCollector.addError((Throwable)new ErrorCollectorTestException("ErrorCollector Test - Exception 1/2."));
        this.errorCollector.addError((Throwable)new ErrorCollectorTestException("ErrorCollector Test - Exception 2/2."));
        this.exception.expect(MultipleFailureException.class);
    }

    @Test
    public void screenshotCapturerTest() {
        this.errorCollector.addError((Throwable)new ErrorCollectorTestException("ErrorCollector Test - Exception 1/2."));
        this.errorCollector.addError((Throwable)new ErrorCollectorTestException("ErrorCollector Test - Exception 2/2."));
        this.exception.expect(MultipleFailureException.class);
        Assert.assertEquals((long)2L, (long)this.getFiles(this.errorCollector.getScreenshotDirPath(), ".*screenshotCapturerTest.*\\.png").length);
    }

    public File[] getFiles(String directory, String pattern) {
        return new File(directory).listFiles(new FileNameFilter(pattern));
    }

    public class ErrorCollectorTestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ErrorCollectorTestException(String message) {
            super(message);
        }
    }

    public class FileNameFilter
    implements FilenameFilter {
        String regexp;

        public FileNameFilter(String regexp) {
            this.regexp = regexp;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(this.regexp);
        }
    }
}

