/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class ShellRule
extends AbstractSimpleRedDeerRule {
    private int shellAction;

    public boolean appliesTo(Event event) {
        if (event.widget instanceof Shell && event.type == 26) {
            if (RedDeerUtils.getActiveShell() != null && RedDeerUtils.getActiveShell().getShellTitle().equals(((Shell)event.widget).getText())) {
                return false;
            }
            if (RedDeerUtils.getWorkbench() != null) {
                return !RedDeerUtils.getWorkbench().getText().equals(((Shell)event.widget).getText());
            }
            return true;
        }
        if (event.widget instanceof Shell && event.type == 12) {
            RedDeerUtils.setActiveShell(null);
        }
        return event.widget instanceof Shell && event.type == 21;
    }

    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.shellAction = event.type;
        this.setShellTitle(((Shell)event.widget).getText());
        if (this.shellAction == 21) {
            RedDeerUtils.setActiveShell(null);
        } else {
            RedDeerUtils.setActiveShell(this);
        }
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("new DefaultShell(\"" + this.getShellTitle() + "\")");
        if (this.shellAction == 21) {
            builder.append(".close()");
        }
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.swt.impl.shell.DefaultShell");
        return toReturn;
    }

    public int getShellAction() {
        return this.shellAction;
    }

    public void setShellAction(int shellAction) {
        this.shellAction = shellAction;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.shellAction;
        result = 31 * result + (this.getShellTitle() == null ? 0 : this.getShellTitle().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ShellRule other = (ShellRule)((Object)obj);
        if (this.shellAction != other.shellAction) {
            return false;
        }
        return !(this.getShellTitle() == null ? other.getShellTitle() != null : !this.getShellTitle().equals(other.getShellTitle()));
    }
}

