/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.test.expandablecomposite;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.uiforms.impl.expandablecomposite.DefaultExpandableComposite;
import org.eclipse.reddeer.uiforms.impl.form.DefaultForm;
import org.eclipse.reddeer.uiforms.test.ui.views.UIFormView;
import org.eclipse.reddeer.workbench.api.View;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultExpandableCompositeTest {
    private View uiFormView = new UIFormView();

    @Before
    public void openView() {
        this.uiFormView.open();
    }

    @Test
    public void defaultConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultExpandableComposite().getText(), (Matcher)Is.is((Object)"Expandable composite A"));
    }

    @Test
    public void indexedConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultExpandableComposite(1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Expandable composite B"));
    }

    @Test
    public void titleConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultExpandableComposite("Expandable composite C").getText(), (Matcher)Is.is((Object)"Expandable composite C"));
    }

    @Test
    public void defaultConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultExpandableComposite((ReferencedComposite)rc).getText(), (Matcher)Is.is((Object)"Expandable composite C"));
    }

    @Test
    public void indexedConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultExpandableComposite((ReferencedComposite)rc, 1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Expandable composite D"));
    }

    @Test
    public void titleConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultExpandableComposite((ReferencedComposite)rc, "Expandable composite C").getText(), (Matcher)Is.is((Object)"Expandable composite C"));
    }

    @Test(expected=CoreLayerException.class)
    public void testInvalidInstance() {
        new DefaultExpandableComposite("Non existing expandable composite title");
    }

    @Test
    public void testExpanded_true() {
        DefaultExpandableComposite composite = new DefaultExpandableComposite();
        composite.setExpanded(true);
        Assert.assertTrue((boolean)composite.isExpanded());
        Assert.assertNotNull((Object)new DefaultText((ReferencedComposite)composite, "Value: "));
    }

    @Test(expected=CoreLayerException.class)
    public void testExpanded_false() {
        DefaultExpandableComposite composite = new DefaultExpandableComposite();
        composite.setExpanded(false);
        Assert.assertFalse((boolean)composite.isExpanded());
        new DefaultText((ReferencedComposite)composite, "Value: ");
    }
}

