/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.test.hyperlink;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.label.DefaultLabel;
import org.eclipse.reddeer.uiforms.impl.form.DefaultForm;
import org.eclipse.reddeer.uiforms.impl.hyperlink.DefaultHyperlink;
import org.eclipse.reddeer.uiforms.test.ui.views.UIFormView;
import org.eclipse.reddeer.workbench.api.View;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultHyperlinkTest {
    private View uiFormView = new UIFormView();

    @Before
    public void openView() {
        this.uiFormView.open();
    }

    @Test
    public void defaultConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultHyperlink().getText(), (Matcher)Is.is((Object)"Hyperlink Section A"));
    }

    @Test
    public void indexedConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultHyperlink(1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Hyperlink Section B"));
    }

    @Test
    public void titleConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultHyperlink("Hyperlink Section B").getText(), (Matcher)Is.is((Object)"Hyperlink Section B"));
    }

    @Test
    public void defaultConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultHyperlink((ReferencedComposite)rc).getText(), (Matcher)Is.is((Object)"Hyperlink Section C"));
    }

    @Test
    public void indexedConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultHyperlink((ReferencedComposite)rc, 1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Hyperlink Section D"));
    }

    @Test
    public void titleConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultHyperlink((ReferencedComposite)rc, "Hyperlink Section C").getText(), (Matcher)Is.is((Object)"Hyperlink Section C"));
    }

    @Test(expected=CoreLayerException.class)
    public void testInvalidInstance() {
        new DefaultHyperlink("Non existing hyperlink");
    }

    @Test
    public void activate() {
        DefaultHyperlink link = new DefaultHyperlink();
        link.activate();
        Assert.assertNotNull((Object)new DefaultLabel("Hyperlink clicked"));
    }
}

