/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.test.ui.views;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;

public class FormView
extends ViewPart {
    public static final String HYPERLINK_PREFIX = "Hyperlink ";
    public static final String FORMTEXT_PREFIX = "FormText ";
    public static final String ACTIVATED_HYPERLINK = "Hyperlink clicked";
    public static final String ACTIVATED_FORMTEXT = "FormText clicked";
    public static final String EXPANDABLE_COMPOSITE_A = "Expandable composite A";
    public static final String EXPANDABLE_COMPOSITE_B = "Expandable composite B";
    public static final String EXPANDABLE_COMPOSITE_C = "Expandable composite C";
    public static final String EXPANDABLE_COMPOSITE_D = "Expandable composite D";
    public static final String SECTION_A = "Section A";
    public static final String SECTION_B = "Section B";
    public static final String SECTION_C = "Section C";
    public static final String SECTION_D = "Section D";
    public static final String FORM_A_TITLE = "Form A";
    public static final String FORM_B_TITLE = "Form B";
    public static final String FORM_C_TITLE = "Form C";
    public static final String FORM_D_TITLE = "Form D";
    private FormToolkit toolkit;
    private ScrolledForm formA;
    private ScrolledForm formB;
    private ScrolledForm formC;
    private ScrolledForm formD;

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.formA = this.toolkit.createScrolledForm(parent);
        this.formA.setText(FORM_A_TITLE);
        this.formA.getBody().setLayout((Layout)new GridLayout(1, true));
        this.formB = this.toolkit.createScrolledForm(parent);
        this.formB.setText(FORM_B_TITLE);
        this.formB.getBody().setLayout((Layout)new GridLayout(1, true));
        this.formC = this.toolkit.createScrolledForm(this.formB.getBody());
        this.formC.setText(FORM_C_TITLE);
        this.formD = this.toolkit.createScrolledForm(this.formB.getBody());
        this.formD.setText(FORM_D_TITLE);
        this.createSectionWithHyperLink(this.formA, SECTION_A);
        this.createSectionWithHyperLink(this.formA, SECTION_B);
        this.createSectionWithHyperLink(this.formB, SECTION_C);
        this.createSectionWithHyperLink(this.formB, SECTION_D);
        this.createExpandableCompositeWithHyperLink(this.formA, EXPANDABLE_COMPOSITE_A);
        this.createExpandableCompositeWithHyperLink(this.formA, EXPANDABLE_COMPOSITE_B);
        this.createExpandableCompositeWithHyperLink(this.formB, EXPANDABLE_COMPOSITE_C);
        this.createExpandableCompositeWithHyperLink(this.formB, EXPANDABLE_COMPOSITE_D);
    }

    public void setFocus() {
        this.formA.setFocus();
    }

    private void createExpandableCompositeWithHyperLink(final ScrolledForm form, String text) {
        ExpandableComposite composite = this.toolkit.createExpandableComposite(form.getBody(), 274);
        composite.setText(text);
        Composite c = this.toolkit.createComposite((Composite)composite);
        GridLayout l = new GridLayout(1, true);
        l.horizontalSpacing = 10;
        c.setLayout((Layout)l);
        this.toolkit.createText(c, "Value: ");
        this.createHyperlink(text, c);
        this.createFormText(text, c);
        composite.setClient((Control)c);
        composite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        composite.setExpanded(true);
    }

    private void createSectionWithHyperLink(ScrolledForm form, String text) {
        Section section = this.toolkit.createSection(form.getBody(), 256);
        section.setText(text);
        Composite c = this.toolkit.createComposite((Composite)section);
        GridLayout l = new GridLayout(1, true);
        l.horizontalSpacing = 10;
        c.setLayout((Layout)l);
        this.toolkit.createText(c, "Value: ");
        this.createHyperlink(text, c);
        this.createFormText(text, c);
        section.setClient((Control)c);
    }

    private void createHyperlink(String text, final Composite c) {
        Hyperlink link = this.toolkit.createHyperlink(c, HYPERLINK_PREFIX + text, 0);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent arg0) {
            }

            public void linkActivated(HyperlinkEvent arg0) {
                new Label(c, 16384).setText(FormView.ACTIVATED_HYPERLINK);
                c.layout();
            }
        });
    }

    private void createFormText(String text, final Composite c) {
        FormText formText = this.toolkit.createFormText(c, true);
        formText.setText("<form><p><a href=\"link\">FormText " + text + "</a></p></form>", true, false);
        formText.setToolTipText(FORMTEXT_PREFIX + text + "tooltip");
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object object = e.data;
                if (object instanceof String) {
                    new Label(c, 16384).setText(FormView.ACTIVATED_FORMTEXT);
                    c.layout();
                }
            }
        });
    }
}

