/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.logparser.editors;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.reddeer.logparser.LogParserActivator;
import org.eclipse.reddeer.logparser.LogParserLog;
import org.eclipse.reddeer.logparser.editors.ReadOnlyTextEditor;
import org.eclipse.reddeer.logparser.model.LogData;
import org.eclipse.reddeer.logparser.model.ParseRule;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class LogParserEditor
extends MultiPageEditorPart {
    public static final String ID = "org.eclipse.reddeer.logparser.editors.LogParserEditor";
    private static Image findPrevImage;
    private static Image findNextImage;
    private static Image closeFindCompositeImage;
    private ReadOnlyTextEditor sourceTextEditor;
    private StyledText parsedLogStyledText;
    private TreeMap<Integer, Integer> parsedLineNumToOrigLineNum;
    private Text findText;
    private Label findStatusLabel;
    private Composite findComposite;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IURIEditorInput)) {
            throw new PartInitException("Invalid input it must be IURIEditorInput instance");
        }
        super.init(site, input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 0: {
                this.parsedLogStyledText.setFocus();
                break;
            }
            case 1: {
                this.sourceTextEditor.setFocus();
            }
        }
    }

    public void refreshLog() {
        try {
            this.sourceTextEditor.getDocumentProvider().resetDocument((Object)this.sourceTextEditor.getEditorInput());
        }
        catch (CoreException ce) {
            LogParserLog.logError("Unable to refresh editor content", ce);
        }
    }

    protected void createPages() {
        this.createParsedLogPage();
        this.createSourcePage();
        this.updateTitle();
        this.setParsedLogFont();
        this.createContextMenu();
    }

    private void createParsedLogPage() {
        Composite parsedLogPageComposite = new Composite(this.getContainer(), 0);
        parsedLogPageComposite.setLayout((Layout)new GridLayout(1, false));
        parsedLogPageComposite.setLayoutData((Object)new GridData(1808));
        this.parsedLogStyledText = new StyledText(parsedLogPageComposite, 68362);
        this.parsedLogStyledText.setText("To parse Log select log within Log Parser view\n and click on 'Parse Log' tool item");
        this.parsedLogStyledText.setLayoutData((Object)new GridData(1808));
        this.findComposite = new Composite(parsedLogPageComposite, 2048);
        this.findComposite.setLayout((Layout)new GridLayout(6, false));
        this.findComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(this.findComposite, 0);
        label.setText("Find: ");
        this.findText = new Text(this.findComposite, 2048);
        GridData gdText = new GridData();
        gdText.widthHint = 250;
        this.findText.setLayoutData((Object)gdText);
        LogParserEditor.initializeImages();
        final Button prevButton = new Button(this.findComposite, 8);
        prevButton.setImage(findPrevImage);
        prevButton.setToolTipText("Find previous occurrence");
        prevButton.setEnabled(false);
        prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserEditor.this.findString(false);
            }
        });
        final Button nextButton = new Button(this.findComposite, 8);
        nextButton.setImage(findNextImage);
        nextButton.setToolTipText("Find next occurrence");
        nextButton.setEnabled(false);
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserEditor.this.findString(true);
            }
        });
        this.findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LogParserEditor.this.findText.getText().length() > 0) {
                    prevButton.setEnabled(true);
                    nextButton.setEnabled(true);
                } else {
                    prevButton.setEnabled(false);
                    nextButton.setEnabled(false);
                }
            }
        });
        this.findStatusLabel = new Label(this.findComposite, 0);
        this.findStatusLabel.setLayoutData((Object)new GridData(768));
        Button closeFindButton = new Button(this.findComposite, 8);
        closeFindButton.setImage(closeFindCompositeImage);
        closeFindButton.setToolTipText("Close find composite");
        closeFindButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserEditor.this.closeFindComposite();
            }
        });
        int pageIndex = this.addPage((Control)parsedLogPageComposite);
        this.setPageText(pageIndex, "Parsed Log");
    }

    private void createSourcePage() {
        this.sourceTextEditor = new ReadOnlyTextEditor();
        try {
            int pageIndex = this.addPage((IEditorPart)this.sourceTextEditor, this.getEditorInput());
            this.setPageText(pageIndex, "Original Log");
        }
        catch (PartInitException pie) {
            LogParserLog.logError("Unable to initiliaze Original Log page of LogParser editor", pie);
        }
    }

    private void updateTitle() {
        IEditorInput editorInput = this.getEditorInput();
        this.setPartName(String.valueOf(editorInput.getName()) + " (read-only)");
        this.setTitleToolTip(editorInput.getToolTipText());
    }

    public void parseLog(LogData logData) {
        this.parsedLogStyledText.setText("");
        if (this.parsedLineNumToOrigLineNum == null) {
            this.parsedLineNumToOrigLineNum = new TreeMap();
        } else {
            this.parsedLineNumToOrigLineNum.clear();
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(this.sourceTextEditor.getDocumentProvider().getDocument((Object)this.sourceTextEditor.getEditorInput()).get()));
        try {
            String line;
            TreeMap<Integer, String> originalLogLines = new TreeMap<Integer, String>();
            TreeMap<Integer, ParseRule> parsedLogIncludeLines = new TreeMap<Integer, ParseRule>();
            while ((line = lineNumberReader.readLine()) != null) {
                int lineNumber = lineNumberReader.getLineNumber();
                originalLogLines.put(lineNumber, line);
                boolean notIncludeLine = true;
                ParseRule parseRule = this.getDefaultParseRule();
                if (logData.getParseRules() != null && !logData.getParseRules().isEmpty() && line != null && line.length() > 0) {
                    boolean excludeRegexNotApplied = true;
                    Iterator<ParseRule> itParseRule = logData.getParseRules().iterator();
                    while (notIncludeLine && excludeRegexNotApplied && itParseRule.hasNext()) {
                        parseRule = itParseRule.next();
                        boolean includeRegexMatches = true;
                        if (parseRule.getIncludeRegex() != null && parseRule.getIncludeRegex().length() > 0) {
                            includeRegexMatches = line.matches(parseRule.getIncludeRegex());
                        }
                        if (!includeRegexMatches) continue;
                        if (parseRule.getExcludeRegex() != null && parseRule.getExcludeRegex().length() > 0) {
                            notIncludeLine = line.matches(parseRule.getExcludeRegex());
                            if (!notIncludeLine) continue;
                            excludeRegexNotApplied = false;
                            continue;
                        }
                        notIncludeLine = false;
                    }
                } else {
                    boolean bl = notIncludeLine = line == null || line.length() == 0;
                }
                if (notIncludeLine) continue;
                int addLinesFrom = lineNumber;
                int addLinesTo = lineNumber;
                if ((addLinesFrom -= parseRule.getDisplayLinesBefore()) < 0) {
                    addLinesFrom = 0;
                }
                addLinesTo += parseRule.getDisplaylinesAfter();
                int addLineNumber = addLinesFrom;
                while (addLineNumber <= addLinesTo) {
                    if (!parsedLogIncludeLines.containsKey(addLineNumber)) {
                        parsedLogIncludeLines.put(addLineNumber, parseRule);
                    }
                    ++addLineNumber;
                }
            }
            Iterator itIncludeLine = parsedLogIncludeLines.keySet().iterator();
            int addLineNumber = 0;
            while (itIncludeLine.hasNext()) {
                int originalLineNumber = (Integer)itIncludeLine.next();
                parsedLogIncludeLines.get(originalLineNumber);
                String originalLine = (String)originalLogLines.get(originalLineNumber);
                if (originalLine == null) continue;
                ParseRule appliedParseRule = (ParseRule)parsedLogIncludeLines.get(originalLineNumber);
                String insertLine = originalLine;
                insertLine = String.valueOf(this.fillString(appliedParseRule.getIndent(), ' ')) + appliedParseRule.getPrefix() + originalLine;
                this.parsedLogStyledText.append(String.valueOf(insertLine) + "\n");
                this.parsedLineNumToOrigLineNum.put(addLineNumber, originalLineNumber);
                ++addLineNumber;
            }
        }
        catch (IOException ioe) {
            LogParserLog.logError("Error while parsing log", ioe);
        }
    }

    public void showSelectedParsedLineInOriginalLog() {
        int selectedParsedLine = this.parsedLogStyledText.getLineAtOffset(this.parsedLogStyledText.getSelection().x);
        this.setActivePage(1);
        int selectedOriginalLine = 0;
        selectedOriginalLine = this.parsedLineNumToOrigLineNum.get(selectedParsedLine);
        Integer integerLineNum = selectedOriginalLine;
        if (integerLineNum != null) {
            selectedOriginalLine = integerLineNum - 1;
        }
        this.getSourceEditorStyledText().setSelection(this.getSourceEditorStyledText().getOffsetAtLine(selectedOriginalLine));
    }

    public static void disposeImages() {
        if (findPrevImage != null) {
            findPrevImage.dispose();
            findPrevImage = null;
        }
        if (findNextImage != null) {
            findNextImage.dispose();
            findNextImage = null;
        }
        if (closeFindCompositeImage != null) {
            closeFindCompositeImage.dispose();
            closeFindCompositeImage = null;
        }
    }

    private static void initializeImages() {
        if (findPrevImage == null) {
            findPrevImage = LogParserActivator.getImageDescriptor("icons/prev.gif").createImage();
        }
        if (findNextImage == null) {
            findNextImage = LogParserActivator.getImageDescriptor("icons/next.gif").createImage();
        }
        if (closeFindCompositeImage == null) {
            closeFindCompositeImage = LogParserActivator.getImageDescriptor("icons/closefind.gif").createImage();
        }
    }

    private void findString(boolean forward) {
        String searchFor = this.findText.getText();
        if (searchFor != null && searchFor.length() > 0 && this.parsedLogStyledText.getText().length() > 0) {
            int searchLineIndex = this.parsedLogStyledText.getLineAtOffset(this.parsedLogStyledText.getSelection().x);
            int searchColumnIndex = this.parsedLogStyledText.getSelection().y - this.parsedLogStyledText.getOffsetAtLine(searchLineIndex);
            String searchText = this.parsedLogStyledText.getLine(searchLineIndex);
            int foundIndex = -1;
            if (forward) {
                foundIndex = (searchText = searchText.substring(searchColumnIndex)).indexOf(searchFor);
                if (foundIndex != -1) {
                    foundIndex += searchColumnIndex;
                } else {
                    ++searchLineIndex;
                }
            } else {
                if (searchColumnIndex > 0) {
                    searchText = searchText.substring(0, searchColumnIndex - 1);
                    foundIndex = searchText.lastIndexOf(searchFor);
                }
                if (foundIndex == -1) {
                    --searchLineIndex;
                }
            }
            while (foundIndex == -1 && searchLineIndex >= 0 && searchLineIndex < this.parsedLogStyledText.getLineCount()) {
                if (forward) {
                    foundIndex = this.parsedLogStyledText.getLine(searchLineIndex).indexOf(searchFor);
                    if (foundIndex != -1) continue;
                    ++searchLineIndex;
                    continue;
                }
                foundIndex = this.parsedLogStyledText.getLine(searchLineIndex).lastIndexOf(searchFor);
                if (foundIndex != -1) continue;
                --searchLineIndex;
            }
            if (foundIndex != -1) {
                int start = this.parsedLogStyledText.getOffsetAtLine(searchLineIndex) + foundIndex;
                this.parsedLogStyledText.setSelection(start, start + searchFor.length());
                this.findStatusLabel.setText("");
            } else {
                this.findStatusLabel.setText("Text not found.");
            }
        }
    }

    private void closeFindComposite() {
        ((GridData)this.findComposite.getLayoutData()).exclude = true;
        this.findComposite.setVisible(false);
        this.findComposite.getShell().layout(true, true);
    }

    public void showFindComposite() {
        if (!this.findComposite.isVisible()) {
            ((GridData)this.findComposite.getLayoutData()).exclude = false;
            this.findComposite.setVisible(true);
            this.findComposite.getShell().layout(true, true);
        }
        this.findText.setText(this.parsedLogStyledText.getSelectionText());
    }

    private ParseRule getDefaultParseRule() {
        ParseRule defautlParseRule = new ParseRule();
        defautlParseRule.setIncludeRegex("");
        defautlParseRule.setExcludeRegex("");
        defautlParseRule.setIndent(0);
        defautlParseRule.setDisplayLinesBefore(0);
        defautlParseRule.setDisplaylinesAfter(0);
        defautlParseRule.setPrefix("");
        return defautlParseRule;
    }

    private String fillString(int length, char charToFill) {
        String result = "";
        if (length > 0) {
            char[] array = new char[length];
            Arrays.fill(array, charToFill);
            result = new String(array);
        }
        return result;
    }

    private void setParsedLogFont() {
        this.parsedLogStyledText.setFont(this.getSourceEditorStyledText().getFont());
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                LogParserEditor.this.fillContextMenu(m);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.parsedLogStyledText);
        this.parsedLogStyledText.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, null);
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private StyledText getSourceEditorStyledText() {
        Object control = this.sourceTextEditor.getAdapter(Control.class);
        return (StyledText)control;
    }
}

