/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test.installation.common.dialog;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.integration.test.installation.common.condition.DialogTitleIsFound;
import org.eclipse.reddeer.jface.api.Window;
import org.eclipse.reddeer.jface.condition.WindowIsAvailable;
import org.eclipse.reddeer.jface.dialogs.TitleAreaDialog;
import org.eclipse.reddeer.jface.window.Openable;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.workbench.workbenchmenu.WorkbenchMenuOpenable;

public class InstallNewSoftwareDialog
extends WizardDialog {
    public static final String TITLE = "Install";
    public static final String[] PATH = new String[]{"Help", "Install New Software..."};
    protected final Logger log = Logger.getLogger(InstallNewSoftwareDialog.class);
    protected WorkbenchMenuOpenable openable = new WorkbenchMenuOpenable("Install", PATH);

    public void open() {
        super.open();
        new WaitUntil((WaitCondition)new ShellIsAvailable(TITLE), TimePeriod.LONG);
    }

    protected Openable getOpenAction() {
        return this.openable;
    }

    public WizardDialog next() {
        String pageTitle = this.getTitle();
        super.next();
        new WaitWhile((WaitCondition)new DialogTitleIsFound((TitleAreaDialog)this, pageTitle), TimePeriod.getCustom((long)600L));
        return this;
    }

    public void finish(TimePeriod timeout) {
        this.checkShell();
        this.log.info("Finish wizard - overriden");
        FinishButton button = new FinishButton((ReferencedComposite)this);
        button.click();
        new WaitWhile((WaitCondition)new WindowIsAvailable((Window)this), timeout);
    }
}

