/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.integration.runner.order;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.test.integration.runner.IAfterTestImpl;
import org.eclipse.reddeer.junit.test.integration.runner.IBeforeTestImpl;
import org.eclipse.reddeer.junit.test.integration.runner.order.OrderRunnerRequirement;
import org.eclipse.reddeer.junit.test.integration.runner.order.TestSequence;
import org.eclipse.reddeer.junit.test.integration.runner.order.TestSequenceRedDeerSuite;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class RequirementsOrderRunnerSuite
extends TestSequenceRedDeerSuite {
    private static final List<Object> expectedSequence = new ArrayList<Object>();

    static {
        expectedSequence.add(TestSequence.createIBeforeClass(IBeforeTestImpl.class));
        expectedSequence.add(TestSequence.createFulfill(OrderRunnerRequirement.class));
        expectedSequence.add(TestSequence.createReqBeforeClass(OrderRunnerRequirement.class));
        expectedSequence.add(TestSequence.createBeforeClass(RequirementsOrderRunnerSuite.class));
        expectedSequence.add(TestSequence.createIBefore(IBeforeTestImpl.class));
        expectedSequence.add(TestSequence.createReqBefore(OrderRunnerRequirement.class));
        expectedSequence.add(TestSequence.createBefore(RequirementsOrderRunnerSuite.class));
        expectedSequence.add(TestSequence.createTest(RequirementsOrderRunnerSuite.class));
        expectedSequence.add(TestSequence.createAfter(RequirementsOrderRunnerSuite.class));
        expectedSequence.add(TestSequence.createReqAfter(OrderRunnerRequirement.class));
        expectedSequence.add(TestSequence.createIAfter(IAfterTestImpl.class));
        expectedSequence.add(TestSequence.createAfterClass(RequirementsOrderRunnerSuite.class));
        expectedSequence.add(TestSequence.createReqAfterClass(OrderRunnerRequirement.class));
        expectedSequence.add(TestSequence.createCleanup(OrderRunnerRequirement.class));
        expectedSequence.add(TestSequence.createIAfterClass(IAfterTestImpl.class));
    }

    @Override
    protected List<?> getExpectedSequence() {
        return expectedSequence;
    }

    public RequirementsOrderRunnerSuite(Class<?> clazz, RunnerBuilder builder, SuiteConfiguration config) throws InitializationError {
        super(clazz, builder, config);
    }

    public RequirementsOrderRunnerSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        super(clazz, builder);
    }

    public static List<?> getStaticExpectedSequence() {
        return expectedSequence;
    }

    public static class RequirementOrderErroneousTest
    extends RequirementOrderParentTest {
        @Test
        public void test() {
            TestSequence.addTest(RequirementsOrderRunnerSuite.class);
            throw new RedDeerException("Test in error");
        }
    }

    public static class RequirementOrderFailedTest
    extends RequirementOrderParentTest {
        @Test
        public void test() {
            TestSequence.addTest(RequirementsOrderRunnerSuite.class);
            Assert.assertTrue((String)"Test in failure", (boolean)false);
        }
    }

    @RunWith(value=RequirementsOrderRunnerSuite.class)
    @OrderRunnerRequirement.RequirementOrderAnnotation
    public static class RequirementOrderParentTest {
        @BeforeClass
        public static void beforeClass() {
            TestSequence.addBeforeClass(RequirementsOrderRunnerSuite.class);
        }

        @Before
        public void before() {
            TestSequence.addBefore(RequirementsOrderRunnerSuite.class);
        }

        @After
        public void after() {
            TestSequence.addAfter(RequirementsOrderRunnerSuite.class);
        }

        @AfterClass
        public static void afterClass() {
            TestSequence.addAfterClass(RequirementsOrderRunnerSuite.class);
        }
    }

    public static class RequirementOrderPassedTest
    extends RequirementOrderParentTest {
        @Test
        public void test() {
            TestSequence.addTest(RequirementsOrderRunnerSuite.class);
        }
    }
}

