/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.reddeer.codegen.CodeGenerator;
import org.eclipse.reddeer.codegen.wizards.CodeGenWizard;
import org.eclipse.reddeer.codegen.wizards.FirstPage;
import org.eclipse.reddeer.codegen.wizards.MethodsPage;
import org.eclipse.reddeer.codegen.wizards.PreviewPage;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CodeGenHandler
extends AbstractHandler {
    private final Logger log = Logger.getLogger(CodeGenHandler.class);
    private Shell lastActiveShell;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.lastActiveShell = ShellLookup.getInstance().getCurrentActiveShell();
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.openCodeGen(window);
        window.getShell().getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.stateMask == 65536 && e.keyCode == 103) {
                    CodeGenHandler.this.log.info("Shortcut 'ALT + G' was captured.");
                    CodeGenHandler.this.openCodeGen(window);
                }
            }
        });
        return null;
    }

    private void openCodeGen(IWorkbenchWindow window) {
        Shell[] shell;
        this.log.info("Trying to open CodeGen wizard.");
        Shell[] shellArray = shell = ShellLookup.getInstance().getShells();
        int n = shell.length;
        int n2 = 0;
        while (n2 < n) {
            Shell sh = shellArray[n2];
            if (sh.getText() == "RedDeer CodeGen") {
                return;
            }
            ++n2;
        }
        CodeGenWizard wizard = new CodeGenWizard();
        final WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(150, 350);
        dialog.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                CodeGenHandler.this.log.info("Page changed listener was started.");
                Object selected = event.getSelectedPage();
                if (selected instanceof PreviewPage) {
                    PreviewPage cfr_ignored_0 = (PreviewPage)((Object)selected);
                    CodeGenHandler.this.log.debug("Active page -> 'PreviewPage'.");
                    dialog.updateButtons();
                } else if (selected instanceof MethodsPage) {
                    CodeGenHandler.this.log.debug("Active page -> 'MethodsPage'.");
                } else if (selected instanceof FirstPage) {
                    CodeGenHandler.this.log.debug("Active page -> 'FirstPage'.");
                    ((FirstPage)((Object)selected)).dialogChanged();
                    dialog.updateButtons();
                }
            }
        });
        dialog.addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                CodeGenHandler.this.log.info("Page changing listener was started.");
                Object current = event.getCurrentPage();
                Object target = event.getTargetPage();
                if (current instanceof MethodsPage && target instanceof PreviewPage) {
                    CodeGenHandler.this.log.debug("Switching between 'MethodsPage' -> 'PreviewPage'.");
                    MethodsPage meth = (MethodsPage)((Object)current);
                    PreviewPage prev = (PreviewPage)((Object)target);
                    CodeGenHandler.this.log.info("Trying to generate code.");
                    CodeGenerator g = new CodeGenerator(meth.getClassBuilder().getClassName(), meth.getClassBuilder().getPackageName(), meth.getSelectedOptional());
                    CodeGenHandler.this.log.info("Trying to update text area in 'PreviewPage'.");
                    g.setLastActiveShell(CodeGenHandler.this.lastActiveShell);
                    prev.updateAreaContent(g.generateCode());
                }
            }
        });
        this.log.info("Opening WizardDialog -> " + wizard.getWindowTitle() + "...");
        dialog.open();
    }
}

