/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public abstract class AbstractStatementWithScreenshot
extends Statement {
    private static final Logger log = Logger.getLogger(AbstractStatementWithScreenshot.class);
    protected String config;
    protected Statement nextStatement;
    protected TestClass testClass;
    protected FrameworkMethod frameworkMethod;
    protected Object target;

    public AbstractStatementWithScreenshot(String config, Statement next, TestClass testClass, FrameworkMethod method, Object target) {
        this.config = config;
        this.nextStatement = next;
        this.testClass = testClass;
        this.frameworkMethod = method;
        this.target = target;
    }

    protected boolean isClassLevel() {
        return this.target == null;
    }

    protected void createScreenshot() {
        try {
            ScreenshotCapturer capturer = ScreenshotCapturer.getInstance();
            capturer.captureScreenshotOnFailure(this.config, this.getScreenshotFilename());
        }
        catch (CaptureScreenshotException ex) {
            ex.printInfo(log);
        }
    }

    protected void createScreenshot(String description) {
        try {
            ScreenshotCapturer capturer = ScreenshotCapturer.getInstance();
            capturer.captureScreenshotOnFailure(this.config, this.getScreenshotFilename(description));
        }
        catch (CaptureScreenshotException ex) {
            ex.printInfo(log);
        }
    }

    protected void createScreenshot(String description, Class<?> extensionClass) {
        try {
            ScreenshotCapturer capturer = ScreenshotCapturer.getInstance();
            capturer.captureScreenshotOnFailure(this.config, this.getScreenshotFilename(description, extensionClass));
        }
        catch (CaptureScreenshotException ex) {
            ex.printInfo(log);
        }
    }

    private String getScreenshotFilename(String description, Class<?> extraClass) {
        String methodName = this.frameworkMethod != null ? this.frameworkMethod.getName() : null;
        return ScreenshotCapturer.getScreenshotFileName(this.testClass.getJavaClass(), methodName, String.valueOf(description) + "_" + extraClass.getSimpleName());
    }

    private String getScreenshotFilename(String description) {
        String methodName = this.frameworkMethod != null ? this.frameworkMethod.getName() : null;
        return ScreenshotCapturer.getScreenshotFileName(this.testClass.getJavaClass(), methodName, description);
    }

    private String getScreenshotFilename() {
        String methodName = this.frameworkMethod != null ? this.frameworkMethod.getName() : null;
        return ScreenshotCapturer.getScreenshotFileName(this.testClass.getJavaClass(), methodName, null);
    }
}

