/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.cleanworkspace;

import java.lang.reflect.Field;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.runner.RequirementsRunner;
import org.eclipse.reddeer.junit.internal.runner.RequirementsRunnerBuilder;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;

@RunWith(value=RedDeerSuite.class)
public class CleanWorkspaceRequirementTest {
    RequirementsRunnerBuilder builder;
    Requirements requirements;

    @Before
    public void setUp() {
        this.builder = new RequirementsRunnerBuilder(new RequirementConfigurationSet());
        Runner runner = null;
        try {
            runner = this.builder.runnerForClass(TestClass.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!(runner instanceof RequirementsRunner)) {
            Assert.fail();
        }
        RequirementsRunner reqRunner = (RequirementsRunner)runner;
        this.requirements = null;
        try {
            Field field = RequirementsRunner.class.getDeclaredField("requirements");
            field.setAccessible(true);
            this.requirements = (Requirements)field.get(reqRunner);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void fulfillWithoutProjectsTest() {
        this.requirements.fulfill();
    }

    @Test
    public void fulfillWithProjectsTest() {
        JavaProjectWizard projectWizard = new JavaProjectWizard();
        projectWizard.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)projectWizard).setProjectName("TestProject");
        projectWizard.finish();
        PackageExplorerPart packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        Assert.assertFalse((String)"Project should be imported, but isn't", (boolean)packageExplorer.getProjects().isEmpty());
    }

    @CleanWorkspaceRequirement.CleanWorkspace
    public static class TestClass {
        @Test
        public void voidTest() {
        }
    }
}

