/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test.installation.common.page;

import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.integration.test.installation.common.dialog.InstallNewSoftwareDialog;
import org.eclipse.reddeer.integration.test.installation.common.page.ValidatedWizardPage;
import org.eclipse.reddeer.jface.dialogs.TitleAreaDialog;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.hamcrest.Matcher;

public class AvailableSoftwarePage
extends ValidatedWizardPage {
    public static final String PAGE_TITLE = "Available Software";

    public AvailableSoftwarePage(InstallNewSoftwareDialog installNewSoftwareDialog) {
        super((TitleAreaDialog)installNewSoftwareDialog, PAGE_TITLE);
    }

    public void addUpdateSite(String source) {
        new PushButton(this.referencedComposite, "Add...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Add Repository"), TimePeriod.LONG);
        new LabeledText("Location:").setText(source);
        try {
            new OkButton().click();
        }
        catch (CoreLayerException | SWTLayerException throwable) {
            new PushButton(new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher(".*A.*dd.*"))}).click();
        }
        new WaitWhile((WaitCondition)new ShellIsAvailable("Add Repository"), TimePeriod.LONG);
        this.waitUntillUIsAreLoaded();
    }

    public void selectSoftware(String pattern) {
        RegexMatcher matcher = new RegexMatcher(pattern);
        for (TreeItem item : new DefaultTree(this.referencedComposite).getItems()) {
            String text = item.getText();
            if (!matcher.matches((Object)text)) continue;
            item.setChecked(true);
            this.log.info("Item " + item.getText() + " selected to be installed.");
        }
    }

    public List<TableItem> getItems() {
        this.waitUntillUIsAreLoaded();
        return new DefaultTable(this.referencedComposite).getItems();
    }

    protected void waitUntillUIsAreLoaded() {
        new WaitWhile((WaitCondition)new AbstractWaitCondition(){

            public boolean test() {
                DefaultTree tree = new DefaultTree(AvailableSoftwarePage.this.referencedComposite);
                if (tree.getItems().size() == 0) {
                    return true;
                }
                for (TreeItem item : tree.getItems()) {
                    if (!item.isDisposed() && !item.getText().equals("Pending...")) continue;
                    return true;
                }
                return false;
            }

            public String description() {
                return "Tree has no items.";
            }
        }, TimePeriod.LONG);
    }
}

