/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test.installation.common.util;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.integration.test.installation.common.page.RemediationActionPage;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.junit.rules.ErrorCollector;

public class RemediationActionValidator {
    private static Logger LOG = Logger.getLogger(RemediationActionValidator.class);

    public static boolean validateSolution(RemediationActionPage remetiationPage, ErrorCollector collector) {
        DefaultTree solutionTree = remetiationPage.getSolutionsDetailsTree();
        boolean uninstallSectionFound = false;
        boolean notInstallSectionFound = false;
        boolean installSectionFound = false;
        boolean upgradeSectionFound = false;
        StringBuilder sb = new StringBuilder("Solution details:\n");
        for (TreeItem item : solutionTree.getItems()) {
            sb.append(String.valueOf(item.getCell(0)) + "\n");
            for (TreeItem subItem : item.getItems()) {
                sb.append("-Name: " + subItem.getCell(0) + " Version: " + subItem.getCell(1) + " Id: " + subItem.getCell(2) + "\n");
            }
            switch (item.getCell(0)) {
                case "Will be uninstalled": {
                    uninstallSectionFound = true;
                    break;
                }
                case "Will not be installed": {
                    notInstallSectionFound = true;
                    break;
                }
                case "Will be installed": {
                    installSectionFound = true;
                    break;
                }
                case "Will be upgraded/downgraded": {
                    upgradeSectionFound = true;
                }
            }
        }
        LOG.debug(sb.toString());
        StringBuilder result = new StringBuilder();
        if (uninstallSectionFound) {
            result.append("-remediation action want to uninstall some plugins\n");
        }
        if (notInstallSectionFound) {
            result.append("-remediation action want to skip some plugins\n");
        }
        if (!installSectionFound && !upgradeSectionFound) {
            result.append("-remediation action doesn't want to install/update any plugins\n");
        }
        if (!result.toString().isEmpty()) {
            collector.addError((Throwable)((Object)new AssertionError((Object)("Remediation action validation:\n" + result.toString()))));
            return false;
        }
        return true;
    }
}

