/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.internal.requirement;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.RequirementsBuilder;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.configuration.MissingRequirementConfiguration;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;
import org.eclipse.reddeer.junit.test.internal.requirement.TestRequirementA;
import org.eclipse.reddeer.junit.test.internal.requirement.TestRequirementB;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.JavaRequirement;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.JavaRequirementConfig;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

public class RequirementsBuilderTest {
    private RequirementsBuilder builder = new RequirementsBuilder();

    @Test(expected=IllegalArgumentException.class)
    public void testNullClassArgument() {
        this.builder.build(new RequirementConfigurationSet(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullConfigArgument() {
        this.builder.build(null, this.getClass());
    }

    @Test
    public void testBuildNoRequirements() {
        RequirementConfigurationSet configurationSet = new RequirementConfigurationSet();
        configurationSet.setConfigurations(new HashSet());
        Requirements requirements = this.builder.build(configurationSet, this.getClass());
        Assert.assertTrue((String)"There should be no requirements, but there are some.", (requirements.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildRequirements() {
        RequirementConfigurationSet configurationSet = new RequirementConfigurationSet();
        configurationSet.setConfigurations(new HashSet());
        Requirements requirements = this.builder.build(configurationSet, RequirementClass.class);
        Assert.assertTrue((String)("There should be precisely 2 requirements, but there is/are " + requirements.size()), (requirements.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildRequirementsWithConfigurableRequirementWithoutConfiguration() {
        RequirementConfigurationSet configurationSet = new RequirementConfigurationSet();
        configurationSet.addConfiguration((RequirementConfiguration)new MissingRequirementConfiguration());
        Requirements requirements = this.builder.build(configurationSet, ConfigurableRequirementClass.class);
        Assert.assertTrue((String)("There should be no requirement, but there is/are " + requirements.size()), (requirements.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildRequirementsWithConfiguredRequirement() {
        RequirementConfigurationSet configurationSet = new RequirementConfigurationSet();
        configurationSet.addConfiguration((RequirementConfiguration)new JavaRequirementConfig());
        Requirements requirements = this.builder.build(configurationSet, ConfigurableRequirementClass.class);
        Assert.assertTrue((String)("There should be precisely 1 requirements, but there is/are " + requirements.size()), (requirements.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildRequiremenetsWithMixedRequirements() {
        RequirementConfigurationSet configurationSet = new RequirementConfigurationSet();
        configurationSet.addConfiguration((RequirementConfiguration)new JavaRequirementConfig());
        configurationSet.addConfiguration((RequirementConfiguration)new JavaRequirementConfig());
        Requirements requirements = this.builder.build(configurationSet, CombinedRequirementsClass.class);
        Assert.assertTrue((String)("There should be precisely 2 requirements, but there is/are " + requirements.size()), (requirements.size() == 2 ? 1 : 0) != 0);
    }

    @TestRequirementA.TestRequirementAAnnotation
    @JavaRequirement.CustomConfigJavaRequirementAAnnotation
    class CombinedRequirementsClass {
        CombinedRequirementsClass() {
        }
    }

    @JavaRequirement.CustomConfigJavaRequirementAAnnotation
    class ConfigurableRequirementClass {
        ConfigurableRequirementClass() {
        }
    }

    @TestRequirementA.TestRequirementAAnnotation
    @TestRequirementB.TestRequirementBAnnotation
    class RequirementClass {
        RequirementClass() {
        }
    }

    class RequirementClassMatcher
    extends TypeSafeMatcher<Requirement<?>> {
        private Class<?> requirementClass;
        private Class<?> requirementDeclaration;

        public RequirementClassMatcher(Class<?> requirementClass, Class<?> requirementAnnotation) {
            this.requirementClass = requirementClass;
            this.requirementDeclaration = requirementAnnotation;
        }

        public boolean matchesSafely(Requirement<?> item) {
            return this.requirementClass.equals(item.getClass()) && this.requirementDeclaration.equals(this.getDeclaration(item).annotationType());
        }

        public void describeTo(Description description) {
            description.appendText("instance of ");
            description.appendValue(this.requirementClass);
            description.appendText(" with declaration annotation of type ");
            description.appendValue(this.requirementDeclaration);
        }

        private Annotation getDeclaration(Requirement<?> requirement) {
            try {
                return (Annotation)requirement.getClass().getDeclaredMethod("getDeclaration", new Class[0]).invoke(requirement, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

