/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.clabel;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithIdMatcher;
import org.eclipse.reddeer.swt.impl.clabel.DefaultCLabel;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CLabelTest
extends SWTLayerTestCase {
    private static final String CLABEL_PREFIX = "CLabel:";
    private static final String CLABEL_TOOLTIP_PREFIX = "CLabel Tooltip Text:";

    @Override
    protected void createControls(Shell shell) {
        this.createCLabel(shell, "CLabel:0", 16384, null);
        this.createCLabel(shell, "CLabel:1", 0x1000000, Display.getDisplay().getSystemImage(4));
        this.createCLabel(shell, "CLabel:2", 131072, null);
    }

    private CLabel createCLabel(Shell shell, String text, int align, Image image) {
        CLabel cLabel = new CLabel((Composite)shell, 4);
        cLabel.setText(text);
        cLabel.setToolTipText(CLABEL_TOOLTIP_PREFIX + text);
        cLabel.setAlignment(align);
        cLabel.setImage(image);
        cLabel.setData((Object)("id#" + text));
        return cLabel;
    }

    @Test
    public void findCLabelByIndex() {
        DefaultCLabel cLabel = new DefaultCLabel(1, new Matcher[0]);
        Assert.assertEquals((String)"Wrong cLabel widget was found", (Object)"CLabel:1", (Object)cLabel.getText());
    }

    @Test
    public void findCLabelById() {
        DefaultCLabel cLabel = new DefaultCLabel(new Matcher[]{new WithIdMatcher(null, (Object)"id#CLabel:1")});
        Assert.assertEquals((String)"Wrong cLabel widget was found", (Object)"CLabel:1", (Object)cLabel.getText());
    }

    @Test
    public void findCLabelByText() {
        DefaultCLabel cLabel = new DefaultCLabel("CLabel:1");
        Assert.assertEquals((String)"Wrong cLabel widget was found", (Object)"CLabel:1", (Object)cLabel.getText());
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingCLabelByIndex() {
        new DefaultCLabel(11, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingCLabelByText() {
        new DefaultCLabel("NON_ESITING_@##$_TEXT");
    }

    @Test
    public void getTooltipText() {
        String tooltip = new DefaultCLabel(1, new Matcher[0]).getToolTipText();
        Assert.assertEquals((String)"CLabel has wrong tooltip", (Object)"CLabel Tooltip Text:CLabel:1", (Object)tooltip);
    }

    @Test
    public void getAlignment() {
        int alignmemt = new DefaultCLabel(1, new Matcher[0]).getAlignment();
        Assert.assertEquals((String)"CLabel has wrong Alignment: ", (long)0x1000000L, (long)alignmemt);
    }

    @Test
    public void hasImage() {
        Assert.assertTrue((String)"Clabel should not have an image", (new DefaultCLabel(0, new Matcher[0]).getImage() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Clabel should have an image", (new DefaultCLabel(1, new Matcher[0]).getImage() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Clabel should not have an image", (new DefaultCLabel(2, new Matcher[0]).getImage() == null ? 1 : 0) != 0);
    }
}

