/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.shell;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.OkCancelShell;
import org.eclipse.reddeer.swt.test.utils.ShellTestUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class OkCancelShellTest {
    protected static final String SHELL_TITLE = "Testing shell";
    private Button okButton;
    private Button cancelButton;
    private ButtonClickListener okListener;
    private ButtonClickListener cancelListener;

    @Before
    public void setUp() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = ShellTestUtils.createShell(OkCancelShellTest.SHELL_TITLE);
                OkCancelShellTest.this.okButton = new Button((Composite)shell, 8);
                OkCancelShellTest.this.okButton.setText("OK");
                OkCancelShellTest.this.okListener = new ButtonClickListener();
                OkCancelShellTest.this.okButton.addListener(13, (Listener)OkCancelShellTest.this.okListener);
                OkCancelShellTest.this.cancelButton = new Button((Composite)shell, 8);
                OkCancelShellTest.this.cancelButton.setText("Cancel");
                OkCancelShellTest.this.cancelListener = new ButtonClickListener();
                OkCancelShellTest.this.cancelButton.addListener(13, (Listener)OkCancelShellTest.this.cancelListener);
            }
        });
    }

    @Test
    public void okAndCancelButtonsTest() {
        OkCancelShell shell = new OkCancelShell(SHELL_TITLE);
        shell.ok();
        try {
            new WaitUntil((WaitCondition)new ButtonHeardClickNotification(this.okListener));
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"OK button didn't registered click event.");
        }
        shell.cancel();
        try {
            new WaitUntil((WaitCondition)new ButtonHeardClickNotification(this.cancelListener));
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"Cancel button didn't registered click event.");
        }
    }

    @After
    public void cleanup() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ShellTestUtils.closeShell(OkCancelShellTest.SHELL_TITLE);
            }
        });
    }

    public class ButtonClickListener
    implements Listener {
        private boolean heard = false;

        public void handleEvent(Event e) {
            switch (e.type) {
                case 13: {
                    this.heard = true;
                }
            }
        }

        public boolean isHeard() {
            return this.heard;
        }
    }

    private class ButtonHeardClickNotification
    extends AbstractWaitCondition {
        private ButtonClickListener listener;

        public ButtonHeardClickNotification(ButtonClickListener listener) {
            this.listener = listener;
        }

        public boolean test() {
            return this.listener.isHeard();
        }

        public String description() {
            return "button heard click notification";
        }
    }
}

