/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.shell;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.label.DefaultLabel;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultShellTest {
    private org.eclipse.reddeer.swt.api.Shell shell1;
    private org.eclipse.reddeer.swt.api.Shell shell2;

    @Test
    public void defaultShellTest() {
        DefaultShell shell = new DefaultShell();
        Assert.assertFalse((boolean)shell.getText().equals(""));
    }

    @Test
    public void closeShellTest() {
        org.eclipse.reddeer.common.util.Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Display display = org.eclipse.reddeer.common.util.Display.getDisplay();
                Shell shell = new Shell(display);
                shell.setText("Dummy shell");
                shell.open();
                shell.setFocus();
            }
        });
        DefaultShell dummyShell = new DefaultShell("Dummy shell");
        dummyShell.close();
    }

    @Test
    public void activateShellTest() {
        DefaultShellTest.createSimpleShell("Shell 1");
        DefaultShellTest.createSimpleShell("Shell 2");
        this.shell2 = new DefaultShell("Shell 2");
        new DefaultLabel("Shell 2");
        this.shell1 = new DefaultShell("Shell 1");
        new DefaultLabel("Shell 1");
        new DefaultShell("Shell 2");
        new DefaultLabel("Shell 2");
        try {
            new DefaultLabel("Shell 1");
            Assert.fail((String)"Label 'Shell 1' should be in inactive shell!");
        }
        catch (CoreLayerException coreLayerException) {}
    }

    @Test
    public void testEmptyTitleShell() {
        DefaultShellTest.createSimpleShell("");
        this.shell1 = new DefaultShell("");
        Assert.assertTrue((boolean)this.shell1.getText().equals(""));
    }

    @Test
    public void testEmptyTitleShellWithCondition() {
        DefaultShellTest.createSimpleShell("");
        this.shell1 = new DefaultShell("");
        Assert.assertTrue((boolean)this.shell1.getText().equals(""));
    }

    @Test
    public void manipulateShellTest() {
        DefaultShellTest.createSimpleShell("MaxMin");
        this.shell1 = new DefaultShell("MaxMin");
        this.shell1.maximize();
        Assert.assertTrue((boolean)this.shell1.isMaximized());
        this.shell1.restore();
        Assert.assertFalse((boolean)this.shell1.isMaximized());
        this.shell1.minimize();
        Assert.assertTrue((boolean)this.shell1.isMinimized());
        this.shell1.restore();
        Assert.assertFalse((boolean)this.shell1.isMinimized());
    }

    private static void createSimpleShell(final String title) {
        org.eclipse.reddeer.common.util.Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Display display = org.eclipse.reddeer.common.util.Display.getDisplay();
                Shell shell = new Shell(display);
                shell.setText(title);
                Label swtLabel = new Label((Composite)shell, 2048);
                swtLabel.setText(title);
                swtLabel.setSize(100, 30);
                swtLabel.setLocation(100, 50);
                shell.open();
            }
        });
    }

    @After
    public void tearDown() {
        if (this.shell1 != null) {
            this.shell1.close();
        }
        if (this.shell2 != null) {
            this.shell2.close();
        }
    }
}

