/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui.test.wizard;

import java.util.Collection;
import java.util.List;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.core.resources.Resource;
import org.eclipse.reddeer.eclipse.selectionwizard.NewMenuWizard;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.AbstractMarkerMatcher;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.MarkerResourceMatcher;
import org.eclipse.reddeer.eclipse.ui.problems.Problem;
import org.eclipse.reddeer.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.reddeer.eclipse.ui.views.markers.ProblemsView;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.ui.test.wizard.RedDeerWizardTestCase;
import org.eclipse.reddeer.ui.test.wizard.impl.RedDeerTestPluginWizard;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RedDeerTestPluginWizardTest
extends RedDeerWizardTestCase {
    private static final String BUNDLE_REDDEER_GO = "org.eclipse.reddeer.go";
    private static final String BUNDLE_ORG_JUNIT = "org.junit";
    protected static NewMenuWizard wizard;

    @Override
    public String getWizardText() {
        return "New RedDeer Test Plugin";
    }

    @Before
    public void open() {
        wizard.open();
    }

    @After
    public void closeWizard() {
        this.closeOpenedWizard(wizard);
    }

    @BeforeClass
    public static void setup() {
        wizard = new RedDeerTestPluginWizard();
        projectName = "test.plugin";
    }

    @Test
    public void testOpen() {
        Assert.assertEquals((Object)("New " + "RedDeer Test Plug-in".replace("-", "")), (Object)new DefaultShell().getText());
        Assert.assertTrue((String)"Product id radio is not selected", (boolean)new RadioButton("Product id:").isSelected());
        Assert.assertTrue((String)"Product combo is not enabled", (boolean)new DefaultCombo().isEnabled());
        Assert.assertFalse((String)"Application id radio is selected", (boolean)new RadioButton("Application id:").isSelected());
        Assert.assertFalse((String)"Application combo not enabled", (boolean)new DefaultCombo(1, new Matcher[0]).isEnabled());
        Assert.assertFalse((String)"Finish button is enabled", (boolean)new FinishButton().isEnabled());
    }

    @Test
    public void testCreate() {
        RedDeerTestPluginWizardTest.fillInWizard(wizard);
        wizard.finish();
        DefaultProject project = this.getProject("test.plugin");
        this.checkProjectResources(project);
        this.checkJavaVersion(project);
        this.checkManifest(project);
        this.checkExampleTest(project);
        this.checkForCompilationErrors(project);
    }

    private void checkJavaVersion(DefaultProject project) {
        Assert.assertTrue((boolean)project.containsResource(new String[]{"JRE System Library"}));
        Resource resource = project.getResource(new String[]{"JRE System Library"});
        Assert.assertTrue((String)"Cannot find proper java version", (boolean)resource.getDecoratedParts()[0].toString().contains("JavaSE-1.8"));
    }

    private void checkExampleTest(DefaultProject project) {
        project.getProjectItem(EXAMPLE_TEST_CLASS_PATH).open();
        ContentOutline view = new ContentOutline();
        view.open();
        Collection outline = view.outlineElements();
        TreeItem testMethod = null;
        for (TreeItem item : outline) {
            if (!item.getText().equals("RedDeerTest")) continue;
            for (TreeItem member : item.getItems()) {
                if (!member.getText().equals("redDeerTestExample() : void")) continue;
                testMethod = member;
            }
        }
        Assert.assertNotNull((String)"Cannot locate example test method", testMethod);
    }

    private void checkManifest(DefaultProject project) {
        project.getProjectItem(new String[]{"META-INF", "MANIFEST.MF"}).open();
        Assert.assertTrue((boolean)new LabeledText("ID:").getText().equals("test.plugin"));
        Assert.assertTrue((boolean)new LabeledText("Version:").getText().equals("8.2.9.qualifier"));
        Assert.assertTrue((boolean)new LabeledText("Name:").getText().equals("reddeer.test.plugin"));
        Assert.assertTrue((boolean)new LabeledText("Vendor:").getText().equals("Eclipse.org - RedDeer"));
        ContentOutline outline = new ContentOutline();
        outline.open();
        for (TreeItem item : outline.outlineElements()) {
            if (!item.getText().equals("Dependencies")) continue;
            item.expand();
            Assert.assertNotNull((Object)item.getItem(BUNDLE_REDDEER_GO));
            Assert.assertNotNull((Object)item.getItem(BUNDLE_ORG_JUNIT));
        }
    }

    private void checkProjectResources(DefaultProject project) {
        Assert.assertTrue((String)"Project does not contain build.properties file", (boolean)project.containsResource(new String[]{"build.properties"}));
        Assert.assertTrue((String)"Project does not contain pluginCustomization.ini file", (boolean)project.containsResource(new String[]{"pluginCustomization.ini"}));
        Assert.assertTrue((String)"Project does not contain MANIFEST.MF file", (boolean)project.containsResource(new String[]{"META-INF", "MANIFEST.MF"}));
        Assert.assertTrue((String)"Project does not contain example test", (boolean)project.containsResource(new String[]{"src", "org.reddeer.test", "RedDeerTest.java"}));
        Assert.assertTrue((String)"Project does not contain RedDeerTest.launch file", (boolean)project.containsResource(new String[]{"RedDeerTest.launch"}));
    }

    private void checkForCompilationErrors(DefaultProject project) {
        project.getProjectItem(EXAMPLE_TEST_CLASS_PATH).open();
        ProblemsView view = new ProblemsView();
        view.open();
        List problems = view.getProblems(ProblemsView.ProblemType.ERROR, new AbstractMarkerMatcher[]{new MarkerResourceMatcher("RedDeerTest.java")});
        if (!problems.isEmpty()) {
            String errors = "";
            for (Problem problem : problems) {
                errors = errors.concat(String.valueOf(problem.toString()) + "\r\n");
            }
            Assert.fail((String)("There are compilation errors in RedDeerTest.java class: " + errors));
        }
    }
}

