/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.search;

import org.eclipse.reddeer.eclipse.search2.ui.SearchView;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class SearchViewTest {
    private SearchView searchView;

    @Before
    public void setUp() {
        this.searchView = new SearchView();
    }

    @After
    public void tearDown() {
        if (this.searchView != null && this.searchView.isOpen()) {
            this.searchView.close();
        }
    }

    @Test
    public void testOpen() {
        this.searchView.open();
        String activeViewTitle = WorkbenchPartLookup.getInstance().getActiveWorkbenchPartTitle();
        Assert.assertTrue((String)("Active view has to be Search but is" + activeViewTitle), (boolean)activeViewTitle.equals("Search"));
    }

    @Test
    public void testIsEmpty() {
        this.searchView.open();
        this.searchView.activate();
        Assert.assertTrue((String)"SearchView results are empty when nothing is foudn. ", (boolean)this.searchView.isSearchEmpty());
    }

    @Test
    public void testReturnResults() {
        this.searchView.open();
        this.searchView.activate();
        Assert.assertTrue((String)"Empty search results should return empty list.", (boolean)this.searchView.getSearchResults().isEmpty());
    }
}

