/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.extensionpoint;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;

public class AfterTestInitialization {
    private static final Logger log = Logger.getLogger(AfterTestInitialization.class);

    public static List<IAfterTest> initialize() {
        LinkedList<IAfterTest> afterTestExts = new LinkedList<IAfterTest>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.reddeer.junit.after.test");
        try {
            log.debug("Number of found extensions for extension point org.eclipse.reddeer.junit.after.test=" + configElements.length);
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object object = e.createExecutableExtension("class");
                if (object instanceof IAfterTest) {
                    afterTestExts.add((IAfterTest)object);
                } else {
                    log.warn("Invalid class used for extension point org.eclipse.reddeer.junit.after.test:" + object.getClass());
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            log.error("Error when processing extension for org.jbossreddeer.junit.after.test", new Object[]{ex.getMessage()});
        }
        return afterTestExts;
    }
}

