/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.wizards;

import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.reddeer.codegen.wizards.MethodsPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class FirstPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "codeGenWizardPageOne";
    private ISelection selection;
    private MethodsPage methodsPage;
    private IJavaElement jelem;

    public FirstPage(ISelection selection, MethodsPage methodsPage) {
        super(true, PAGE_NAME);
        this.setTitle("Class definition");
        this.setDescription("This wizard allows generate a new CodeGen class.");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.codegen"), (IPath)new Path("icons/reddeer_logo.png"), null)));
        this.selection = selection;
        this.methodsPage = methodsPage;
    }

    public void init(IStructuredSelection selection) {
        this.jelem = this.getInitialJavaElement(selection);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fModifierStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.setControl((Control)composite);
        this.initContainerPage(this.jelem);
        this.initTypePage(this.jelem);
        this.doStatusUpdate();
        this.dialogChanged();
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
    }

    public boolean canFlipToNextPage() {
        return !this.getPackageFragmentRootText().isEmpty() && !this.getPackageText().isEmpty() && !this.getTypeName().isEmpty();
    }

    protected void handleFieldChanged(String fieldName) {
        if (!fieldName.equals("NewContainerWizardPage.container")) {
            if (fieldName.equals("NewTypeWizardPage.typename")) {
                this.methodsPage.getClassBuilder().setClassName(this.getTypeName());
            } else if (fieldName.equals("NewTypeWizardPage.package")) {
                this.methodsPage.getClassBuilder().setPackage(this.getPackageText());
            }
        }
        this.dialogChanged();
        this.getContainer().updateButtons();
        super.handleFieldChanged(fieldName);
    }

    public void dialogChanged() {
        ICompilationUnit cu;
        IResource resource;
        String fileName = this.getTypeName();
        this.updateStatus(this.containerChanged());
        this.updateStatus(this.packageChanged());
        if (fileName.length() == 0) {
            this.updateStatusMsg("Class name must be specified.");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatusMsg("Class name must be valid.");
            return;
        }
        if (fileName.indexOf(46) != -1) {
            this.updateStatusMsg("Class name must not be qualified.");
            return;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null && (resource = (cu = pack.getCompilationUnit(this.getCompilationUnitName(fileName))).getResource()).exists()) {
            this.setMessage("This class name already exists.", 2);
            this.setPageComplete(false);
            return;
        }
        this.doStatusUpdate();
    }

    private void updateStatusMsg(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

