/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.test.condition;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.test.condition.JobTestBase;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class JobIsRunningTest
extends JobTestBase {
    private static final String TEST_JOB_PREFIX = JobIsRunningTest.class + "_TEST_JOB_";
    private static final String TEST_JOB_1 = String.valueOf(TEST_JOB_PREFIX) + 1;
    private static final String TEST_JOB_2 = String.valueOf(TEST_JOB_PREFIX) + 2;
    private static final String TEST_JOB_3 = String.valueOf(TEST_JOB_PREFIX) + 3;
    private static final String TEST_JOB_4 = String.valueOf(TEST_JOB_PREFIX) + 4;

    @Test
    public void testSimple() {
        String job = TEST_JOB_1;
        this.runParallelyForSeconds(job, 2);
        new WaitWhile((WaitCondition)new JobIsRunning());
        this.assertNotRunning(job);
    }

    @Test
    public void testConsidered() {
        String consideredOne = TEST_JOB_1;
        String consideredTwo = TEST_JOB_2;
        String notConsidered = TEST_JOB_3;
        this.runParallelyForSeconds(consideredOne, 1);
        this.runParallelyForSeconds(consideredTwo, 2);
        this.runParallelyForSeconds(notConsidered, 4);
        new WaitWhile((WaitCondition)new JobIsRunning(new Matcher[]{CoreMatchers.is((Object)consideredOne), CoreMatchers.is((Object)consideredTwo)}));
        this.assertNotRunning(consideredOne);
        this.assertNotRunning(consideredTwo);
        this.assertRunning(notConsidered);
    }

    @Test
    public void testConsideredExcluded() {
        String considered = TEST_JOB_1;
        String excluded = TEST_JOB_2;
        this.runParallelyForSeconds(considered, 6);
        this.runParallelyForSeconds(excluded, 30);
        new WaitWhile((WaitCondition)new JobIsRunning(new Matcher[]{CoreMatchers.is((Object)considered)}, new Matcher[]{CoreMatchers.is((Object)excluded)}));
        this.assertNotRunning(considered);
        this.assertRunning(excluded);
    }

    @Test
    public void testIgnoredSystemJob() {
        this.testSystemJob(true);
    }

    @Test
    public void testNotIgnoredSystemJob() {
        this.testSystemJob(false);
    }

    private void testSystemJob(boolean ignoreSystemJobs) {
        String excludedShort = TEST_JOB_1;
        String considered = TEST_JOB_2;
        String system = TEST_JOB_3;
        String excludedLong = TEST_JOB_4;
        this.runParallelyForSeconds(excludedShort, 3);
        this.runParallelyForSeconds(considered, 6);
        this.runParallelyForSecondsAsSystem(system, 9);
        this.runParallelyForSeconds(excludedLong, 30);
        new WaitWhile((WaitCondition)new JobIsRunning(new Matcher[]{CoreMatchers.is((Object)considered), CoreMatchers.is((Object)system)}, new Matcher[]{CoreMatchers.is((Object)excludedShort), CoreMatchers.is((Object)excludedLong)}, ignoreSystemJobs));
        this.assertNotRunning(excludedShort);
        this.assertNotRunning(considered);
        this.assertRunning(excludedLong);
        if (ignoreSystemJobs) {
            this.assertRunning(system);
        } else {
            this.assertNotRunning(system);
        }
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void testShorterTimeOutThanJobDuration() {
        this.runParallelyForSeconds(TEST_JOB_1, 6);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.getCustom((long)4L));
        Assert.fail((String)"No exception was thrown!");
    }
}

