/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.Text;

public class TextHandler
extends ControlHandler {
    private static TextHandler instance;

    public static TextHandler getInstance() {
        if (instance == null) {
            instance = new TextHandler();
        }
        return instance;
    }

    public void setText(final Text textWidget, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Text textField = textWidget;
                if (!textField.getEditable()) {
                    throw new CoreLayerException("Text field is not editable");
                }
                textField.setText(text);
            }
        });
    }

    public String getText(final Text textWidget) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return textWidget.getText();
            }
        });
    }

    public String getMessage(final Text textWidget) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return textWidget.getMessage();
            }
        });
    }

    public boolean isReadOnly(final Text textWidget) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                if ((textWidget.getStyle() & 8) != 0) {
                    return true;
                }
                return false;
            }
        });
    }
}

