/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.views.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheetProperty;
import org.eclipse.reddeer.eclipse.ui.views.properties.TabbedPropertyList;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class PropertySheet
extends WorkbenchView {
    public PropertySheet() {
        super("Properties");
    }

    public List<PropertySheetProperty> getProperties() {
        this.activate();
        LinkedList<PropertySheetProperty> properties = new LinkedList<PropertySheetProperty>();
        for (TreeItem treeItem : new DefaultTree((ReferencedComposite)this.cTabItem).getAllItems()) {
            properties.add(new PropertySheetProperty(treeItem));
        }
        return properties;
    }

    public PropertySheetProperty getProperty(String ... propertyNamePath) {
        this.activate();
        return new PropertySheetProperty((TreeItem)new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.cTabItem), propertyNamePath));
    }

    public void toggleShowCategories(boolean toggle) {
        this.activate();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Show Categories").toggle(toggle);
    }

    public void toggleShowAdvancedProperties(boolean toggle) {
        this.activate();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Show Advanced Properties").toggle(toggle);
    }

    public void selectTab(String label) {
        this.activate();
        ArrayList<String> old = new ArrayList();
        try {
            old = new TabbedPropertyList((ReferencedComposite)this.cTabItem, 0).getTabs();
        }
        catch (Exception exception) {}
        if (!old.contains(label)) {
            new WaitUntil((WaitCondition)new AnotherTabsRendered(old), TimePeriod.DEFAULT, false);
        }
        new TabbedPropertyList((ReferencedComposite)this.cTabItem, 0).selectTab(label);
    }

    private class AnotherTabsRendered
    extends AbstractWaitCondition {
        private List<String> old;

        public AnotherTabsRendered(List<String> old) {
            this.old = old;
        }

        public boolean test() {
            List<Object> actual = new ArrayList();
            try {
                actual = new TabbedPropertyList((ReferencedComposite)PropertySheet.this.cTabItem, 0).getTabs();
            }
            catch (Exception exception) {}
            return !actual.equals(this.old);
        }

        public String description() {
            return "Wait for tabs of focused element to be rendered";
        }
    }
}

