/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.hamcrest.Matcher;

public class WizardProjectsImportPage
extends WizardPage {
    private static final Logger log = Logger.getLogger(WizardProjectsImportPage.class);

    public WizardProjectsImportPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public WizardProjectsImportPage setRootDirectory(String directory) {
        log.info("Setting root directory to '" + directory + "'");
        this.setPath("Select root directory:", directory);
        return this;
    }

    public WizardProjectsImportPage setArchiveFile(String file) {
        log.info("Settig archive file to '" + file + "'");
        this.setPath("Select archive file:", file);
        return this;
    }

    public WizardProjectsImportPage copyProjectsIntoWorkspace(boolean copy) {
        log.info("Setting copy checkbox to " + copy);
        if (!this.isFileSystem()) {
            throw new EclipseLayerException("You cannot set Copy projects into workspace checkbox when you're importing from ZIP file");
        }
        new CheckBox((ReferencedComposite)this, "Copy projects into workspace").toggle(copy);
        return this;
    }

    public List<ImportProject> getProjects() {
        ArrayList<ImportProject> projects = new ArrayList<ImportProject>();
        Tree projectsTree = this.getProjectsTree();
        for (TreeItem item : projectsTree.getItems()) {
            ImportProject project = new ImportProject();
            project.isChecked = item.isChecked();
            project.name = this.getProjectLabel(item.getText());
            projects.add(project);
        }
        return projects;
    }

    public WizardProjectsImportPage selectProjects(String ... projects) {
        log.info("Selecting projects");
        this.deselectAllProjects();
        Tree projectsTree = this.getProjectsTree();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            TreeItem projectItem = this.getProjectTreeItem(projectsTree, projectName);
            projectItem.setChecked(true);
            ++n2;
        }
        return this;
    }

    public WizardProjectsImportPage selectAllProjects() {
        log.info("Selecting all projects");
        new PushButton((ReferencedComposite)this, "Select All").click();
        return this;
    }

    public WizardProjectsImportPage deselectAllProjects() {
        log.info("Deselecting all projects");
        new PushButton((ReferencedComposite)this, "Deselect All").click();
        return this;
    }

    protected void setPath(String radioText, String path) {
        new RadioButton((ReferencedComposite)this, radioText).click();
        if (radioText.equals("Select root directory:")) {
            new DefaultCombo((ReferencedComposite)this, 0, new Matcher[0]).setText(path);
        } else {
            new DefaultCombo((ReferencedComposite)this, 1, new Matcher[0]).setText(path);
        }
        new PushButton((ReferencedComposite)this, "Refresh").click();
        new WaitUntil((WaitCondition)new ProjectIsLoaded(this.getProjectsTree()), TimePeriod.DEFAULT);
    }

    private boolean isFileSystem() {
        return new RadioButton((ReferencedComposite)this, "Select root directory:").isSelected();
    }

    private Tree getProjectsTree() {
        return new DefaultTree((ReferencedComposite)this);
    }

    private TreeItem getProjectTreeItem(Tree projectsTree, String projectName) {
        for (TreeItem item : projectsTree.getItems()) {
            if (!projectName.equals(this.getProjectLabel(item.getText()))) continue;
            return item;
        }
        throw new IllegalStateException("Project " + projectName + " is not available");
    }

    private String getProjectLabel(String project) {
        return project.substring(0, project.indexOf(40)).trim();
    }

    public static class ImportProject {
        public boolean isChecked;
        public String name;

        public String toString() {
            return "ImportProject[" + this.isChecked + ", " + this.name + "]";
        }
    }

    private class ProjectIsLoaded
    extends AbstractWaitCondition {
        private Tree tree;

        private ProjectIsLoaded(Tree tree) {
            this.tree = tree;
        }

        public boolean test() {
            return !this.tree.getItems().isEmpty();
        }

        public String description() {
            return "at least one project is loaded";
        }
    }
}

