/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.test.wait;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.swt.widgets.Display;

public class CustomWaitCondition
extends AbstractWaitCondition {
    private Runnable runnable = null;
    private int counter = 0;
    private int treshold = 5;
    private boolean initialState = false;
    private boolean conditionChanged = false;

    public CustomWaitCondition(boolean initialState, int treshold, Runnable runnable) {
        this.runnable = runnable;
        this.treshold = treshold;
        this.initialState = initialState;
    }

    public CustomWaitCondition(boolean initialState, int treshold) {
        this(initialState, treshold, null);
    }

    public boolean test() {
        if (this.runnable != null) {
            this.runnable.run();
        }
        ++this.counter;
        if (this.counter >= this.treshold) {
            this.conditionChanged = true;
            return !this.initialState;
        }
        return this.initialState;
    }

    public Boolean getResult() {
        return this.conditionChanged;
    }

    public static void sleep(long milliseconds) {
        Display display = org.eclipse.reddeer.common.util.Display.getDisplay();
        if (display != null && Thread.currentThread().equals(display.getThread())) {
            throw new RuntimeException("Tried to execute sleep in UI thread!");
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Sleep interrupted", e);
        }
    }
}

