/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.views.contentoutline;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.handler.EditorHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class OutlineViewTest {
    private ContentOutline outlineView;
    private static PackageExplorerPart packageExplorer;
    private static final String TEST_PROJECT_NAME = "OutlineViewTestProject";

    @BeforeClass
    public static void prepareWS() {
        OutlineViewTest.createJavaProject();
        OutlineViewTest.createJavaClass();
    }

    @AfterClass
    public static void cleanup() {
        DeleteUtils.forceProjectDeletion((DefaultProject)packageExplorer.getProject(TEST_PROJECT_NAME), (boolean)true);
    }

    @Test
    public void testElementsInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        MatcherAssert.assertThat((Object)this.outlineView.outlineElements().size(), (Matcher)Is.is((Object)0));
    }

    @Test(expected=CoreLayerException.class)
    public void testCollapseInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.collapseAll();
    }

    @Test(expected=CoreLayerException.class)
    public void testSortInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test(expected=CoreLayerException.class)
    public void testHideFieldsInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test(expected=CoreLayerException.class)
    public void testHideStaticFieldsAndMethodsInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test(expected=CoreLayerException.class)
    public void testHideNonPublicMembersInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test(expected=CoreLayerException.class)
    public void testHideLocalTypesInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test(expected=CoreLayerException.class)
    public void testLinkWithEditorInEmptyOutlineView() {
        EditorHandler.getInstance().closeAll(true);
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.linkWithEditor();
    }

    @Test
    public void testElementsInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        MatcherAssert.assertThat((Object)this.outlineView.outlineElements().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testCollapseInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.collapseAll();
    }

    @Test
    public void testSortInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test
    public void testHideFieldsInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test
    public void testHideStaticFieldsAndMethodsInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test
    public void testHideNonPublicMembersInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test
    public void testHideLocalTypesInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.sort();
    }

    @Test(expected=CoreLayerException.class)
    public void testLinkWithEditorInNonEmptyOutlineView() {
        this.openTestClass();
        this.outlineView = new ContentOutline();
        this.outlineView.open();
        this.outlineView.linkWithEditor();
    }

    private static void createJavaProject() {
        JavaProjectWizard javaProject = new JavaProjectWizard();
        javaProject.open();
        NewJavaProjectWizardPageOne javaWizardPage = new NewJavaProjectWizardPageOne((ReferencedComposite)javaProject);
        javaWizardPage.setProjectName(TEST_PROJECT_NAME);
        javaProject.finish();
    }

    private static void createJavaClass() {
        packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        packageExplorer.getProject(TEST_PROJECT_NAME).select();
        NewClassCreationWizard javaClassDialog = new NewClassCreationWizard();
        javaClassDialog.open();
        NewClassWizardPage wizardPage = new NewClassWizardPage((ReferencedComposite)javaClassDialog);
        wizardPage.setName("TestClass");
        wizardPage.setPackage("test");
        wizardPage.setStaticMainMethod(true);
        javaClassDialog.finish();
    }

    private void openTestClass() {
        packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        packageExplorer.getProject(TEST_PROJECT_NAME).getProjectItem(new String[]{"src", "test", "TestClass.java"}).open();
    }
}

