/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServerModule;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServerModuleTest
extends ServersViewTestCase {
    private static final String SERVER = "Server ABC";
    private static Server server;

    @BeforeClass
    public static void createProjects() {
        ServerModuleTest.importProjects();
        ServerModuleTest.createServer(SERVER);
        server = ServerModuleTest.getServersView().getServer(SERVER);
        server.start();
    }

    @AfterClass
    public static void removeProjects() {
        server.stop();
        new CleanWorkspaceRequirement().fulfill();
    }

    @After
    public void removeModules() {
        List modules = server.getModules();
        for (ServerModule module : modules) {
            module.remove();
        }
    }

    @Test
    public void stopServerModule() {
        ServerModule module = this.addServerModule();
        module.stop();
        Assert.assertTrue((boolean)module.getLabel().getState().equals((Object)ServersViewEnums.ServerState.STOPPED));
    }

    @Test
    public void removeServerModule() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        dialog.finish();
        List modules = server.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project"));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(1)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-2"));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(2)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-3"));
        ((ServerModule)modules.get(0)).remove();
        modules = server.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-2"));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(1)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-3"));
    }

    @Test
    public void startServerModule() {
        ServerModule module = this.addServerModule();
        module.start();
        Assert.assertTrue((boolean)module.getLabel().getState().equals((Object)ServersViewEnums.ServerState.STARTED));
    }

    @Test
    public void restartServerModule() {
        ServerModule module = this.addServerModule();
        if (!module.canRestart()) {
            module.start();
        }
        Assert.assertTrue((boolean)module.canRestart());
        module.restart();
        Assert.assertTrue((boolean)module.getLabel().getState().equals((Object)ServersViewEnums.ServerState.STARTED));
    }

    @Test
    public void testGetServerModuleWithPublishState() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        page.togglePublishChanges(true);
        dialog.finish();
        ServerModule thirdModule = server.getModule("server-project");
        Assert.assertTrue((boolean)thirdModule.getLabel().getPublishState().equals((Object)ServersViewEnums.ServerPublishState.SYNCHRONIZED));
    }

    @Test
    public void testGetServerModuleWithServerState() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.add(new String[]{"server-project-2"});
        page.togglePublishChanges(false);
        dialog.finish();
        ((ServerModule)server.getModules().get(0)).start();
        ServerModule module = server.getModule("server-project-2");
        Assert.assertTrue((boolean)module.getLabel().getState().equals((Object)ServersViewEnums.ServerState.STARTED));
    }

    @Test
    public void testGetServerModuleWithNoState() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        page.togglePublishChanges(false);
        dialog.finish();
        ServerModule module = server.getModule("server-project-3");
        MatcherAssert.assertThat((Object)module.getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.NONE));
        MatcherAssert.assertThat((Object)module.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.NONE));
    }

    @Test
    public void testGetServerModuleWithStates() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.add(new String[]{"server-project-3"});
        page.togglePublishChanges(true);
        dialog.finish();
        ((ServerModule)server.getModules().get(0)).start();
        ServerModule module = server.getModule("server-project-3");
        MatcherAssert.assertThat((Object)module.getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.SYNCHRONIZED));
        MatcherAssert.assertThat((Object)module.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.STARTED));
    }

    private ServerModule addServerModule() {
        ModifyModulesDialog mmDialog = server.addAndRemoveModules();
        ModifyModulesPage mmPage = new ModifyModulesPage((ReferencedComposite)mmDialog);
        mmPage.add(new String[]{"server-project"});
        mmDialog.finish();
        return (ServerModule)server.getModules().get(0);
    }
}

