/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.browser;

import java.lang.annotation.Annotation;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.direct.preferences.Preferences;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.browser.InternalBrowserRequirement;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class InternalBrowserRequirementTest {
    private static InternalBrowserRequirement internalRequirement;
    private static InternalBrowserRequirement externalRequirement;
    private static String BROWSER_PLUGIN;
    private static String BROWSER_KEY;

    static {
        BROWSER_PLUGIN = "org.eclipse.ui.browser";
        BROWSER_KEY = "browser-choice";
    }

    @BeforeClass
    public static void setup() {
        internalRequirement = new InternalBrowserRequirement();
        internalRequirement.setDeclaration((Annotation)new InternalBrowserRequirement.UseInternalBrowser(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public boolean cleanup() {
                return true;
            }

            public String browserChoice() {
                return "0";
            }
        });
        externalRequirement = new InternalBrowserRequirement();
        externalRequirement.setDeclaration((Annotation)new InternalBrowserRequirement.UseInternalBrowser(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public boolean cleanup() {
                return false;
            }

            public String browserChoice() {
                return "1";
            }
        });
    }

    @After
    public void cleanup() {
        Preferences.setDefault((String)BROWSER_PLUGIN, (String)BROWSER_KEY);
    }

    @Test
    public void testInternalBrowser() {
        internalRequirement.fulfill();
        Assert.assertEquals((Object)true, (Object)this.internalBrowserUsed());
    }

    @Test
    public void testClenaupAction() {
        internalRequirement.fulfill();
        Assert.assertEquals((Object)"0", (Object)Preferences.get((String)BROWSER_PLUGIN, (String)BROWSER_KEY));
        internalRequirement.cleanUp();
        Assert.assertEquals((Object)"1", (Object)Preferences.get((String)BROWSER_PLUGIN, (String)BROWSER_KEY));
        internalRequirement.fulfill();
        Assert.assertEquals((Object)"0", (Object)Preferences.get((String)BROWSER_PLUGIN, (String)BROWSER_KEY));
        externalRequirement.cleanUp();
        Assert.assertEquals((Object)"0", (Object)Preferences.get((String)BROWSER_PLUGIN, (String)BROWSER_KEY));
    }

    @Test
    public void testExternalBrowserRequirement() {
        internalRequirement.fulfill();
        Assert.assertEquals((Object)true, (Object)this.internalBrowserUsed());
        externalRequirement.fulfill();
        Assert.assertEquals((Object)false, (Object)this.internalBrowserUsed());
    }

    private boolean internalBrowserUsed() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        WebBrowserPreferencePage page = new WebBrowserPreferencePage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)page);
        boolean internalBrowserUsed = page.getInternalBrowserCheckBox().isSelected();
        dialog.cancel();
        return internalBrowserUsed;
    }
}

