/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.core.handler.MenuHandler;
import org.eclipse.reddeer.core.lookup.MenuItemLookup;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatchers;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.Menu;
import org.eclipse.reddeer.swt.impl.menu.DefaultMenu;
import org.eclipse.reddeer.swt.impl.menu.DefaultMenuItem;
import org.eclipse.reddeer.swt.widgets.AbstractWidget;
import org.eclipse.swt.widgets.MenuItem;
import org.hamcrest.Matcher;

public abstract class AbstractMenu
extends AbstractWidget<org.eclipse.swt.widgets.Menu>
implements Menu {
    public AbstractMenu(org.eclipse.swt.widgets.Menu swtMenu) {
        super(swtMenu);
    }

    protected AbstractMenu(Class<org.eclipse.swt.widgets.Menu> widgetClass, ReferencedComposite refComposite, int index, Matcher<?>[] matchers) {
        super(widgetClass, refComposite, index, matchers);
    }

    @Override
    public boolean hasItem(String ... path) {
        Matcher[] matchers = new Matcher[path.length];
        int i = 0;
        while (i < path.length) {
            matchers[i] = new WithMnemonicTextMatcher(path[i]);
            ++i;
        }
        return this.hasItem(matchers);
    }

    @Override
    public boolean hasItem(Matcher<String> ... matchers) {
        if (matchers == null || matchers.length == 0) {
            throw new IllegalArgumentException("Path must contain at least one item");
        }
        Matcher<String> matcher = matchers[0];
        for (org.eclipse.reddeer.swt.api.MenuItem menuItem : this.getItems()) {
            if (!matcher.matches((Object)menuItem.getText())) continue;
            if (matchers.length > 1) {
                return menuItem.getMenu().hasItem(Arrays.copyOfRange(matchers, 1, matchers.length));
            }
            return true;
        }
        return false;
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.MenuItem> getItems() {
        List swtItems = MenuHandler.getInstance().getItems((org.eclipse.swt.widgets.Menu)this.swtWidget);
        if (swtItems == null) {
            return new ArrayList<org.eclipse.reddeer.swt.api.MenuItem>();
        }
        return swtItems.stream().map(DefaultMenuItem::new).collect(Collectors.toList());
    }

    @Override
    public org.eclipse.reddeer.swt.api.MenuItem getItem(Matcher<String> ... matchers) {
        MenuItem swtItem = MenuItemLookup.getInstance().lookFor((org.eclipse.swt.widgets.Menu)this.getSWTWidget(), matchers);
        return new DefaultMenuItem(swtItem);
    }

    @Override
    public org.eclipse.reddeer.swt.api.MenuItem getItem(String ... path) {
        return this.getItem(new WithMnemonicTextMatchers(path).getMatchers());
    }

    @Override
    public boolean isEnabled() {
        return MenuHandler.getInstance().isEnabled((org.eclipse.swt.widgets.Menu)this.swtWidget);
    }

    @Override
    public boolean isVisible() {
        return MenuHandler.getInstance().isVisible((org.eclipse.swt.widgets.Menu)this.swtWidget);
    }

    @Override
    public Menu getParentMenu() {
        org.eclipse.swt.widgets.Menu parentMenu = MenuHandler.getInstance().getParentMenu((org.eclipse.swt.widgets.Menu)this.swtWidget);
        if (parentMenu == null) {
            return null;
        }
        return new DefaultMenu(parentMenu);
    }
}

