/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.test;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.uiforms.impl.form.DefaultForm;
import org.eclipse.reddeer.uiforms.test.ui.views.UIFormView;
import org.eclipse.reddeer.workbench.api.View;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultFormTest {
    private View uiFormView = new UIFormView();
    private View errorLogView = new LogView();

    @Before
    public void openView() {
        this.uiFormView.open();
    }

    @Test
    public void defaultConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultForm().getText(), (Matcher)Is.is((Object)"Form A"));
    }

    @Test
    public void indexedConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultForm(1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Form B"));
    }

    @Test
    public void titleConsturctor() {
        MatcherAssert.assertThat((Object)new DefaultForm("Form B").getText(), (Matcher)Is.is((Object)"Form B"));
    }

    @Test
    public void defaultConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultForm((ReferencedComposite)rc).getText(), (Matcher)Is.is((Object)"Form C"));
    }

    @Test
    public void indexedConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultForm((ReferencedComposite)rc, 1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"Form D"));
    }

    @Test
    public void titleConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultForm((ReferencedComposite)rc, "Form D").getText(), (Matcher)Is.is((Object)"Form D"));
    }

    @Test(expected=CoreLayerException.class)
    public void testInvalidInstance() {
        this.errorLogView.open();
        new DefaultForm();
    }

    @After
    public void tearDown() {
        if (this.errorLogView.isOpen()) {
            this.errorLogView.close();
        }
    }

    class LogView
    extends WorkbenchView {
        public LogView() {
            super("General", "Error Log");
        }
    }
}

