/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.table;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTableItemTest
extends SWTLayerTestCase {
    @Override
    protected void createControls(Shell shell) {
        shell.setLayout((Layout)new GridLayout());
        this.createMULTITable(shell);
        this.createSINGLETable(shell);
    }

    private void createMULTITable(Shell shell) {
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        Table table1 = new Table((Composite)shell, 2);
        table1.setLinesVisible(true);
        table1.setHeaderVisible(true);
        table1.setLayout((Layout)new GridLayout());
        table1.setLayoutData((Object)data);
        String[] titles = new String[]{" ", "C", "!", "Description", "Resource", "In Folder", "Location"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table1, 0);
            column.setText(titles[i]);
            ++i;
        }
        int count = 128;
        int i2 = 0;
        while (i2 < count) {
            TableItem item = new TableItem(table1, 0);
            item.setText(0, "0 " + i2);
            item.setText(1, "y");
            item.setText(2, "!");
            item.setText(3, "this stuff behaves the way I expect");
            item.setText(4, "almost everywhere");
            item.setText(5, "some.folder");
            item.setText(6, "line " + i2 + " in nowhere");
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            table1.getColumn(i2).pack();
            ++i2;
        }
    }

    private void createSINGLETable(Shell shell) {
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        Table table2 = new Table((Composite)shell, 4);
        table2.setLinesVisible(true);
        table2.setHeaderVisible(true);
        table2.setLayout((Layout)new GridLayout());
        table2.setLayoutData((Object)data);
        String[] titles = new String[]{" ", "C", "!", "Description", "Resource", "In Folder", "Location"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table2, 0);
            column.setText(titles[i]);
            ++i;
        }
        int count = 128;
        int i2 = 0;
        while (i2 < count) {
            TableItem item = new TableItem(table2, 0);
            item.setText(0, "1 " + i2);
            item.setText(1, "y");
            item.setText(2, "!");
            item.setText(3, "this stuff behaves the way I expect");
            item.setText(4, "almost everywhere");
            item.setText(5, "some.folder");
            item.setText(6, "line " + i2 + " in nowhere");
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            table2.getColumn(i2).pack();
            ++i2;
        }
        table2.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                Table table = (Table)arg0.widget;
                int index = table.getSelectionIndex();
                TableItem doubleClickedItem = table.getItem(index);
                doubleClickedItem.setText(0, "single click");
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                Table table = (Table)arg0.widget;
                int index = table.getSelectionIndex();
                TableItem doubleClickedItem = table.getItem(index);
                doubleClickedItem.setText(0, "double click");
            }
        });
    }

    @Test
    public void defaultConstructor() {
        MatcherAssert.assertThat((Object)new DefaultTableItem().getText(), (Matcher)Is.is((Object)"0 0"));
    }

    @Test
    public void referencedComposite() {
        MatcherAssert.assertThat((Object)new DefaultTableItem((ReferencedComposite)new DefaultTable(1, new Matcher[0])).getText(), (Matcher)Is.is((Object)"1 0"));
    }

    @Test
    public void index() {
        MatcherAssert.assertThat((Object)new DefaultTableItem(1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"0 1"));
    }

    @Test
    public void referencedComposite_index() {
        MatcherAssert.assertThat((Object)new DefaultTableItem((ReferencedComposite)new DefaultTable(1, new Matcher[0]), 1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"1 1"));
    }

    @Test
    public void text() {
        MatcherAssert.assertThat((Object)new DefaultTableItem("0 3").getText(), (Matcher)Is.is((Object)"0 3"));
    }

    @Test
    public void referencedComposite_text() {
        MatcherAssert.assertThat((Object)new DefaultTableItem((ReferencedComposite)new DefaultTable(1, new Matcher[0]), "1 3").getText(), (Matcher)Is.is((Object)"1 3"));
    }

    @Test
    public void click() {
        DefaultTableItem ti = new DefaultTableItem((ReferencedComposite)new DefaultTable(1, new Matcher[0]), "1 2");
        ti.click();
        Assert.assertEquals((Object)"single click", (Object)ti.getText());
    }

    @Test
    public void setText() {
        new DefaultTableItem((ReferencedComposite)new DefaultTable(0, new Matcher[0]), 6, new Matcher[0]).setText("some text");
        MatcherAssert.assertThat((Object)new DefaultTableItem(6, new Matcher[0]).getText(), (Matcher)Is.is((Object)"some text"));
    }

    @Test
    public void setTextColumn() {
        new DefaultTableItem(7, new Matcher[0]).setText(6, "some text in column");
        MatcherAssert.assertThat((Object)new DefaultTableItem(7, new Matcher[0]).getText(6), (Matcher)Is.is((Object)"some text in column"));
    }

    @Test
    public void setTextStrings() {
        String[] strings = new String[]{"some", "texts", "in", "columns"};
        DefaultTableItem tableItem = new DefaultTableItem((ReferencedComposite)new DefaultTable(0, new Matcher[0]), 7, new Matcher[0]);
        tableItem.setText(strings);
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            MatcherAssert.assertThat((Object)tableItem.getText(i), (Matcher)Is.is((Object)string));
            ++i;
        }
    }
}

