/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.test.formtext;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.label.DefaultLabel;
import org.eclipse.reddeer.uiforms.impl.form.DefaultForm;
import org.eclipse.reddeer.uiforms.impl.formtext.DefaultFormText;
import org.eclipse.reddeer.uiforms.test.ui.views.UIFormView;
import org.eclipse.reddeer.workbench.api.View;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultFormTextTest {
    private View uiFormView = new UIFormView();

    @Before
    public void openView() {
        this.uiFormView.open();
    }

    @Test
    public void defaultConstructor() {
        MatcherAssert.assertThat((Object)new DefaultFormText().getText(), (Matcher)Is.is((Object)"FormText Section A"));
    }

    @Test
    public void indexedConstructor() {
        MatcherAssert.assertThat((Object)new DefaultFormText(1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"FormText Section B"));
    }

    @Test
    public void titleConstructor() {
        MatcherAssert.assertThat((Object)new DefaultFormText("FormText Section A").getText(), (Matcher)Is.is((Object)"FormText Section A"));
    }

    @Test
    public void defaultConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultFormText((ReferencedComposite)rc).getText(), (Matcher)Is.is((Object)"FormText Section C"));
    }

    @Test
    public void indexedConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultFormText((ReferencedComposite)rc, 1, new Matcher[0]).getText(), (Matcher)Is.is((Object)"FormText Section D"));
    }

    @Test
    public void titleConsturctor_referencedComposite() {
        DefaultForm rc = new DefaultForm("Form B");
        MatcherAssert.assertThat((Object)new DefaultFormText((ReferencedComposite)rc, "FormText Section C").getText(), (Matcher)Is.is((Object)"FormText Section C"));
    }

    @Test(expected=CoreLayerException.class)
    public void testInvalidInstance() {
        new DefaultFormText("Non existing hyperlink");
    }

    @Test
    public void clickTest() {
        DefaultFormText formText = new DefaultFormText();
        formText.click();
        Assert.assertNotNull((Object)new DefaultLabel("FormText clicked"));
    }

    @Test
    public void hasFocusTrueTest() {
        DefaultFormText formText = new DefaultFormText();
        formText.setFocus();
        Assert.assertTrue((boolean)formText.isFocusControl());
    }

    @Test
    public void hasFocusFalseTest() {
        DefaultFormText formText0 = new DefaultFormText(0, new Matcher[0]);
        DefaultFormText formText1 = new DefaultFormText(1, new Matcher[0]);
        formText1.setFocus();
        Assert.assertFalse((boolean)formText0.isFocusControl());
    }

    @Test
    public void getTooltipTest() {
        DefaultFormText formText = new DefaultFormText();
        MatcherAssert.assertThat((Object)formText.getToolTipText(), (Matcher)Is.is((Object)"FormText Section Atooltip"));
    }
}

