/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.jface.exception.JFaceLayerException;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.swt.custom.StyleRange;

public class TreeViewerHandler {
    private static TreeViewerHandler instance;

    public static TreeViewerHandler getInstance() {
        if (instance == null) {
            instance = new TreeViewerHandler();
        }
        return instance;
    }

    public TreeItem getTreeItem(Tree tree, String ... path) {
        return this.getTreeItem(tree.getItems().iterator(), path);
    }

    public TreeItem getTreeItem(TreeItem treeItem, String ... path) {
        return this.getTreeItem(treeItem.getItems().iterator(), path);
    }

    private TreeItem getTreeItem(Iterator<TreeItem> iterator, String ... path) {
        List<TreeItem> resultItems = this.getTreeItems(iterator, path);
        if (resultItems.size() > 1) {
            throw new JFaceLayerException("There are more items matching specified path so result is ambiguous. To obtain all such items, please use method getTreeItems with same parameters");
        }
        return resultItems.get(0);
    }

    public List<TreeItem> getTreeItems(Tree tree, String ... path) {
        return this.getTreeItems(tree.getItems().iterator(), path);
    }

    public List<TreeItem> getTreeItems(TreeItem item, String ... path) {
        return this.getTreeItems(item.getItems().iterator(), path);
    }

    private List<TreeItem> getTreeItems(Iterator<TreeItem> iterator, String ... path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("Path to a tree item cannot be null");
        }
        int index = 0;
        Iterator<Object> nestedItemsIterator = iterator;
        ArrayList<TreeItem> resultItems = new ArrayList<TreeItem>();
        while (index < path.length) {
            ArrayList nestedItems = new ArrayList();
            while (nestedItemsIterator.hasNext()) {
                TreeItem item = nestedItemsIterator.next();
                if (!this.getNonStyledText(item).equals(path[index])) continue;
                if (index == path.length - 1) {
                    resultItems.add(item);
                    continue;
                }
                nestedItems.addAll(item.getItems());
            }
            nestedItemsIterator = nestedItems.iterator();
            ++index;
        }
        if (resultItems.size() == 0) {
            throw new JFaceLayerException("There is no tree item with path " + Arrays.toString(path));
        }
        return resultItems;
    }

    private TreeItemTexts parseText(TreeItem item) {
        final org.eclipse.swt.widgets.TreeItem swtTreeItem = (org.eclipse.swt.widgets.TreeItem)item.getSWTWidget();
        return (TreeItemTexts)Display.syncExec((ResultRunnable)new ResultRunnable<TreeItemTexts>(){

            public TreeItemTexts run() {
                String nonStyledText = null;
                String[] styledTexts = null;
                StyleRange[] styleRanges = TreeViewerHandler.this.getStyleRanges(swtTreeItem);
                if (styleRanges == null) {
                    nonStyledText = swtTreeItem.getText().trim();
                    styledTexts = null;
                } else {
                    String rawText = swtTreeItem.getText();
                    String[] tmpStyledTexts = new String[styleRanges.length];
                    String tmpNonStyledText = null;
                    int currentTextIndex = 0;
                    int i = 0;
                    StyleRange[] styleRangeArray = TreeViewerHandler.this.getStyleRanges(swtTreeItem);
                    int n = styleRangeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange range = styleRangeArray[n2];
                        if (range.start > currentTextIndex) {
                            tmpNonStyledText = rawText.substring(currentTextIndex, range.start).trim();
                        }
                        tmpStyledTexts[i] = rawText.substring(range.start, range.start + range.length).trim();
                        currentTextIndex = range.start + range.length;
                        ++i;
                        ++n2;
                    }
                    if (tmpNonStyledText == null) {
                        tmpNonStyledText = rawText.substring(currentTextIndex).trim();
                    }
                    nonStyledText = tmpNonStyledText;
                    styledTexts = tmpStyledTexts;
                }
                return new TreeItemTexts(nonStyledText, styledTexts);
            }
        });
    }

    private StyleRange[] getStyleRanges(org.eclipse.swt.widgets.TreeItem swtTreeItem) {
        Object data = swtTreeItem.getData("org.eclipse.jfacestyled_label_key_0");
        if (data == null) {
            return null;
        }
        if (!(data instanceof StyleRange[])) {
            throw new JFaceLayerException("Cannot parse tree item label. Data for key 'org.eclipse.jfacestyled_label_key_0' are expected to be of type " + StyleRange[].class + " but are " + data.getClass());
        }
        StyleRange[] styles = (StyleRange[])data;
        if (styles.length == 0) {
            return null;
        }
        return styles;
    }

    public String getNonStyledText(TreeItem item) {
        return this.parseText(item).getNonStyledText();
    }

    public String[] getStyledTexts(TreeItem item) {
        return this.parseText(item).getStyledTexts();
    }

    class TreeItemTexts {
        private String nonStyledText;
        private String[] styledTexts;

        public TreeItemTexts(String nonStyledText, String[] styledTexts) {
            this.nonStyledText = nonStyledText;
            this.styledTexts = styledTexts;
        }

        public String getNonStyledText() {
            return this.nonStyledText;
        }

        public String[] getStyledTexts() {
            return this.styledTexts;
        }
    }
}

