/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.requirement.configuration;

import java.io.File;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfigurationPool;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.JavaRequirement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.model.InitializationError;

public class ComplexConfigurationTest {
    private static final String JAVA_CONFIG_FILE = "resources" + File.separator + "java-config.json";
    private SuiteConfiguration config;

    @Before
    public void setup() {
        System.clearProperty(RedDeerProperties.CONFIG_FILE.getName());
        RequirementConfigurationPool.destroyPool();
    }

    @Test
    public void numberOfTestRunsNoConfig() throws InitializationError {
        this.config = new SuiteConfiguration(TestSuite.class);
        MatcherAssert.assertThat((Object)this.config.getConfigurationSetsSuites().keySet().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void numberOfTestRunsWithConfig() throws InitializationError {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JAVA_CONFIG_FILE);
        this.config = new SuiteConfiguration(RequirementJavaClass.class);
        MatcherAssert.assertThat((Object)this.config.getConfigurationSetsSuites().keySet().size(), (Matcher)Matchers.is((Object)3));
        System.clearProperty(RedDeerProperties.CONFIG_FILE.getName());
    }

    @JavaRequirement.CustomConfigJavaRequirementAAnnotation
    private static class RequirementJavaClass {
        private RequirementJavaClass() {
        }
    }

    private static class TestSuite {
        private TestSuite() {
        }
    }
}

