/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.condition;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.eclipse.condition.BrowserContainsText;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.browser.BrowserEditor;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Browser;
import org.eclipse.reddeer.swt.impl.browser.InternalBrowser;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class BrowserContainsTextTest {
    private BrowserEditor browserEditor;
    private static final String URL = "http://www.w3.org/";
    private static final String URL_ECLIPSE = "http://www.eclipse.org/";
    private static final String TEXT_TO_TEST = "World Wide Web Consortium (W3C)";
    private static final String TEXT_TO_TEST_ECLIPSE = "eclipse";

    @Before
    public void openBrowserEditor() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(38, null, "browser", "browser").openURL(new URL(BrowserContainsTextTest.URL));
                }
                catch (PartInitException pie) {
                    throw new EclipseLayerException("Unable to create browser editor", (Throwable)pie);
                }
                catch (MalformedURLException mue) {
                    throw new EclipseLayerException("URL opening in browser is malformed", (Throwable)mue);
                }
            }
        });
        this.browserEditor = new BrowserEditor("browser");
        this.browserEditor.openPageURL(URL);
    }

    @After
    public void tearDown() {
        if (this.browserEditor != null) {
            this.browserEditor.close();
            this.browserEditor = null;
        }
    }

    @Test
    public void testText() {
        BrowserContainsText condition = new BrowserContainsText(TEXT_TO_TEST);
        Assert.assertTrue((boolean)condition.test());
    }

    @Test
    public void testConstructorWithInternalBrowser() {
        InternalBrowser browser = new InternalBrowser();
        browser.setURL(URL_ECLIPSE);
        BrowserContainsText condition = new BrowserContainsText((Browser)browser, TEXT_TO_TEST_ECLIPSE);
        Assert.assertTrue((boolean)condition.test());
    }
}

