/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.integration.runner.injection;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.execution.TestMethodShouldRun;
import org.eclipse.reddeer.junit.execution.annotation.RunIf;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.inject.InjectRequirement;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

@ARequirementImpl.ARequirement
@RunWith(value=RedDeerSuiteExt.class)
public class InjectRequirementsBeforRunIfTest {
    @InjectRequirement
    public static ARequirementImpl aRequirement;

    @Test
    @RunIf(conditionClass={ACondition.class})
    public void test() {
    }

    public static class ACondition
    implements TestMethodShouldRun {
        public boolean shouldRun(FrameworkMethod method) {
            ARequirementImpl aRequirement = InjectRequirementsBeforRunIfTest.aRequirement;
            if (aRequirement == null) {
                Assert.fail((String)"@RunIf is not evaluated after injecting all requirements, see #1368");
            }
            return true;
        }
    }

    public static class ARequirementImpl
    implements Requirement<ARequirement> {
        private String a;

        public boolean canFulfill() {
            return true;
        }

        public void fulfill() {
        }

        public void setDeclaration(ARequirement aRequirement) {
        }

        public void cleanUp() {
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public ARequirement getDeclaration() {
            return null;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface ARequirement {
        }
    }

    public static class RedDeerSuiteExt
    extends RedDeerSuite {
        protected static final String LOCATIONS_ROOT_DIR = "resources/org/eclipse/reddeer/junit/test/integration/runner/injection/fileA.xml";

        public RedDeerSuiteExt(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
            super(RedDeerSuiteExt.heck(clazz), builder);
        }

        protected RedDeerSuiteExt(Class<?> clazz, RunnerBuilder builder, SuiteConfiguration config) throws InitializationError {
            super(clazz, builder, config);
        }

        private static Class<?> heck(Class<?> clazz) {
            System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), LOCATIONS_ROOT_DIR);
            return clazz;
        }
    }
}

