/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.logparser.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.reddeer.logparser.model.LogData;
import org.eclipse.reddeer.logparser.model.ParseRule;
import org.eclipse.reddeer.logparser.preferences.ParseRuleNameSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogParserPropertiesDialog
extends Dialog {
    private LogData logData;
    private List<ParseRule> definedParseRules;
    private List<ParseRule> availableParseRules;
    private List<ParseRule> selectedParseRules;
    private List<LogData> existingLogs;
    private boolean isAdd = false;
    private Text txLocation;
    private ListViewer availableRulesViewer;
    private ListViewer selectedRulesViewer;
    private Button btnAdd;
    private Button btnAddAll;
    private Button btnRemove;
    private Button btnRemoveAll;
    private Button btnMoveUp;
    private Button btnMoveDown;

    public LogParserPropertiesDialog(Shell parentShell, LogData logData, List<ParseRule> definedParseRules, List<LogData> existingLogs) {
        super(parentShell);
        this.logData = logData != null ? logData : new LogData();
        this.definedParseRules = definedParseRules != null ? definedParseRules : new ArrayList();
        this.existingLogs = existingLogs;
        this.isAdd = logData.getLocation() == null || logData.getLocation().length() == 0;
        this.availableParseRules = new ArrayList<ParseRule>(this.definedParseRules);
        if (this.logData != null && logData.getParseRules() != null) {
            this.availableParseRules.removeAll(logData.getParseRules());
            this.selectedParseRules = logData.getParseRules();
            this.selectedParseRules.retainAll(this.definedParseRules);
        } else {
            this.selectedParseRules = new ArrayList<ParseRule>();
        }
        this.setShellStyle(this.getShellStyle() | 0x4F0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite cmpLocation = new Composite(container, 0);
        cmpLocation.setLayout((Layout)new GridLayout(3, false));
        cmpLocation.setLayoutData((Object)new GridData(768));
        Label label = new Label(cmpLocation, 0);
        label.setText("Log location:");
        this.txLocation = new Text(cmpLocation, 2048);
        this.txLocation.setLayoutData((Object)new GridData(768));
        this.txLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserPropertiesDialog.this.setOKButtonSensitivity();
            }
        });
        Button btnBrowse = new Button(cmpLocation, 8);
        GridData gdButton = new GridData();
        gdButton.widthHint = 130;
        btnBrowse.setLayoutData((Object)gdButton);
        btnBrowse.setText("Browse...");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.browseForLog();
            }
        });
        Composite cmpRules = new Composite(container, 0);
        cmpRules.setLayout((Layout)new GridLayout(4, false));
        cmpRules.setLayoutData((Object)new GridData(1808));
        label = new Label(cmpRules, 0);
        label.setText("Avaialable Rules");
        new Label(cmpRules, 0);
        label = new Label(cmpRules, 0);
        label.setText("Selected Rules");
        new Label(cmpRules, 0);
        this.availableRulesViewer = new ListViewer(cmpRules, 2818);
        this.availableRulesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.availableRulesViewer.setSorter((ViewerSorter)new ParseRuleNameSorter());
        this.availableRulesViewer.setLabelProvider((IBaseLabelProvider)new ParseRuleListLabelProvider());
        this.availableRulesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LogParserPropertiesDialog.this.setButtonsSensitivity();
            }
        });
        this.availableRulesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogParserPropertiesDialog.this.addParseRules();
            }
        });
        GridData gdListViewer = new GridData(1808);
        gdListViewer.widthHint = 300;
        gdListViewer.heightHint = 400;
        this.availableRulesViewer.getControl().setLayoutData((Object)gdListViewer);
        Composite cmpAddRemoveBtns = new Composite(cmpRules, 0);
        cmpAddRemoveBtns.setLayout((Layout)new GridLayout(1, false));
        cmpAddRemoveBtns.setLayoutData((Object)new GridData(1040));
        this.btnAdd = new Button(cmpAddRemoveBtns, 8);
        this.btnAdd.setText("Add >>");
        this.btnAdd.setLayoutData((Object)gdButton);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.addParseRules();
            }
        });
        this.btnAddAll = new Button(cmpAddRemoveBtns, 8);
        this.btnAddAll.setText("Add all >>");
        this.btnAddAll.setLayoutData((Object)gdButton);
        this.btnAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.addAllParseRules();
            }
        });
        this.btnRemove = new Button(cmpAddRemoveBtns, 8);
        this.btnRemove.setText("<< Remove");
        this.btnRemove.setLayoutData((Object)gdButton);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.removeParseRules();
            }
        });
        this.btnRemoveAll = new Button(cmpAddRemoveBtns, 8);
        this.btnRemoveAll.setText("<< Remove all");
        this.btnRemoveAll.setLayoutData((Object)gdButton);
        this.btnRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.removeAllParseRules();
            }
        });
        this.selectedRulesViewer = new ListViewer(cmpRules, 2818);
        this.selectedRulesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedRulesViewer.setLabelProvider((IBaseLabelProvider)new ParseRuleListLabelProvider());
        this.selectedRulesViewer.getControl().setLayoutData((Object)gdListViewer);
        this.selectedRulesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LogParserPropertiesDialog.this.setButtonsSensitivity();
            }
        });
        this.selectedRulesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogParserPropertiesDialog.this.removeParseRules();
            }
        });
        Composite cmpMoveUpDownBtns = new Composite(cmpRules, 0);
        cmpMoveUpDownBtns.setLayout((Layout)new GridLayout(1, false));
        cmpMoveUpDownBtns.setLayoutData((Object)new GridData(1040));
        this.btnMoveUp = new Button(cmpMoveUpDownBtns, 8);
        this.btnMoveUp.setText("Move Up");
        this.btnMoveUp.setLayoutData((Object)gdButton);
        this.btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.moveParseRulesUp();
            }
        });
        this.btnMoveDown = new Button(cmpMoveUpDownBtns, 8);
        this.btnMoveDown.setText("Move Down");
        this.btnMoveDown.setLayoutData((Object)gdButton);
        this.btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPropertiesDialog.this.moveParseRulesDown();
            }
        });
        this.initContent();
        this.setButtonsSensitivity();
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.isAdd ? "Add" : "Edit") + " Log to parse");
    }

    public LogData getLogData() {
        return this.logData;
    }

    protected void okPressed() {
        this.saveContent();
        super.okPressed();
    }

    private void initContent() {
        this.availableRulesViewer.setInput(this.availableParseRules);
        this.selectedRulesViewer.setInput(this.selectedParseRules);
        this.txLocation.setText(this.logData.getLocation());
    }

    private void setOKButtonSensitivity() {
        Button btnOK;
        boolean enabled = false;
        if (this.isAdd) {
            enabled = this.txLocation.getText().length() > 0 && this.isLocationUnique(this.txLocation.getText());
        } else {
            boolean bl = enabled = this.txLocation.getText().length() > 0 && (this.txLocation.getText().equalsIgnoreCase(this.logData.getLocation()) || this.isLocationUnique(this.txLocation.getText()));
        }
        if (enabled) {
            enabled = new File(this.txLocation.getText()).exists();
        }
        if ((btnOK = this.getButton(0)) != null) {
            btnOK.setEnabled(enabled);
        }
    }

    private boolean isLocationUnique(String location) {
        boolean isUnique = true;
        if (this.existingLogs != null && this.existingLogs.size() > 0) {
            Iterator<LogData> itLogData = this.existingLogs.iterator();
            while (isUnique && itLogData.hasNext()) {
                if (!location.equalsIgnoreCase(itLogData.next().getLocation())) continue;
                isUnique = false;
            }
        }
        return isUnique;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setOKButtonSensitivity();
    }

    private void browseForLog() {
        String fileName;
        FileDialog fileDialog = new FileDialog(this.btnAdd.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.log", "*.txt", "*.*"});
        fileDialog.setFilterNames(new String[]{"Log files (*.log)", "Text files (*.txt)", "All files (*.*)"});
        if (this.txLocation.getText().length() > 0) {
            fileDialog.setFileName(this.txLocation.getText());
        }
        if ((fileName = fileDialog.open()) != null) {
            this.txLocation.setText(fileName);
        }
    }

    private void saveContent() {
        this.logData.setLocation(this.txLocation.getText());
        this.logData.setParseRules(this.selectedParseRules);
    }

    private void addParseRules() {
        IStructuredSelection selection = this.availableRulesViewer.getStructuredSelection();
        if (selection != null && !selection.isEmpty()) {
            for (ParseRule parseRule : selection) {
                this.selectedParseRules.add(parseRule);
                this.availableParseRules.remove(parseRule);
            }
            this.refreshParseRulesLists();
        }
    }

    private void addAllParseRules() {
        this.selectedParseRules.addAll(this.availableParseRules);
        this.availableParseRules.clear();
        this.refreshParseRulesLists();
    }

    private void removeParseRules() {
        IStructuredSelection selection = this.selectedRulesViewer.getStructuredSelection();
        if (selection != null && !selection.isEmpty()) {
            for (ParseRule parseRule : selection) {
                this.availableParseRules.add(parseRule);
                this.selectedParseRules.remove(parseRule);
            }
            this.refreshParseRulesLists();
        }
    }

    private void removeAllParseRules() {
        this.availableParseRules.addAll(this.selectedParseRules);
        this.selectedParseRules.clear();
        this.refreshParseRulesLists();
    }

    private void moveParseRulesDown() {
        IStructuredSelection selection = this.selectedRulesViewer.getStructuredSelection();
        if (selection != null && !selection.isEmpty()) {
            Iterator itSelection = selection.iterator();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            while (itSelection.hasNext()) {
                ParseRule parseRule = (ParseRule)itSelection.next();
                indices.add(this.selectedParseRules.indexOf(parseRule));
            }
            Collections.sort(indices);
            Collections.reverse(indices);
            if ((Integer)indices.get(0) < this.selectedParseRules.size() - 1) {
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    Collections.swap(this.selectedParseRules, index, index + 1);
                }
            }
            this.selectedRulesViewer.setInput(this.selectedParseRules);
            this.selectedRulesViewer.setSelection((ISelection)selection);
            this.setButtonsSensitivity();
            this.selectedRulesViewer.getControl().setFocus();
        }
    }

    private void moveParseRulesUp() {
        IStructuredSelection selection = this.selectedRulesViewer.getStructuredSelection();
        if (selection != null && !selection.isEmpty()) {
            Iterator itSelection = selection.iterator();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            while (itSelection.hasNext()) {
                ParseRule parseRule = (ParseRule)itSelection.next();
                indices.add(this.selectedParseRules.indexOf(parseRule));
            }
            Collections.sort(indices);
            if ((Integer)indices.get(0) > 0) {
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    Collections.swap(this.selectedParseRules, index - 1, index);
                }
            }
            this.selectedRulesViewer.setInput(this.selectedParseRules);
            this.selectedRulesViewer.setSelection((ISelection)selection);
            this.setButtonsSensitivity();
            this.selectedRulesViewer.getControl().setFocus();
        }
    }

    private void refreshParseRulesLists() {
        this.selectedRulesViewer.setInput(this.selectedParseRules);
        this.availableRulesViewer.setInput(this.availableParseRules);
        this.setButtonsSensitivity();
    }

    private void setButtonsSensitivity() {
        if (this.availableRulesViewer.getSelection().isEmpty()) {
            this.btnAdd.setEnabled(false);
        } else {
            this.btnAdd.setEnabled(true);
        }
        if (this.selectedRulesViewer.getSelection().isEmpty()) {
            this.btnRemove.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            org.eclipse.swt.widgets.List lsSelectedRules = this.selectedRulesViewer.getList();
            int[] selectedIndices = lsSelectedRules.getSelectionIndices();
            if (selectedIndices != null && selectedIndices.length > 0) {
                int minIndex = selectedIndices[0];
                int maxIndex = selectedIndices[0];
                int index = 1;
                while (index < selectedIndices.length) {
                    if (minIndex > selectedIndices[index]) {
                        minIndex = selectedIndices[index];
                    }
                    if (maxIndex < selectedIndices[index]) {
                        maxIndex = selectedIndices[index];
                    }
                    ++index;
                }
                this.btnMoveDown.setEnabled(maxIndex < lsSelectedRules.getItemCount() - 1);
                this.btnMoveUp.setEnabled(minIndex > 0);
            }
        }
        if (this.availableRulesViewer.getList().getItemCount() > 0) {
            this.btnAddAll.setEnabled(true);
        } else {
            this.btnAddAll.setEnabled(false);
        }
        if (this.selectedRulesViewer.getList().getItemCount() > 0) {
            this.btnRemoveAll.setEnabled(true);
        } else {
            this.btnRemoveAll.setEnabled(false);
        }
    }

    private class ParseRuleListLabelProvider
    extends LabelProvider {
        private ParseRuleListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            ParseRule parseRule = (ParseRule)element;
            return String.valueOf(parseRule.getName()) + " [" + (parseRule.getDescription() != null ? parseRule.getDescription() : "no descritpion") + "]";
        }
    }
}

