/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.tree;

import java.util.List;
import org.eclipse.reddeer.core.matcher.WithIdMatcher;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.test.impl.tree.AbstractTreeTest;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTreeTest
extends AbstractTreeTest {
    protected org.eclipse.reddeer.swt.api.Tree tree;

    @Override
    protected void createControls(Shell shell) {
        super.createControls(shell);
    }

    @Before
    public void initTree() {
        this.tree = new DefaultTree();
    }

    @Test
    public void testFindingTreeById() {
        DefaultTree foundTree = new DefaultTree(new Matcher[]{new WithIdMatcher("id", (Object)"tree001")});
        Assert.assertEquals((Object)this.tree.getSWTWidget(), (Object)foundTree.getSWTWidget());
    }

    @Test
    public void testColumnCount() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTree dt = new DefaultTree();
        Assert.assertTrue((String)String.format("DefaultTree should have %d columns, %d reported", 3, dt.getColumnCount()), (dt.getColumnCount() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testColumnHeaders() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTree defaultTree = new DefaultTree();
        List headerColumns = defaultTree.getHeaderColumns();
        Assert.assertTrue((String)("Default tree columns were not obtained correctly. Headers should be [Column1, Column2, Column3] but they were " + headerColumns.toString()), (((String)headerColumns.get(0)).equals("Column1") && ((String)headerColumns.get(1)).equals("Column2") && ((String)headerColumns.get(2)).equals("Column3") ? 1 : 0) != 0);
    }

    @Test
    public void testGetItems_noItems() {
        List items = this.tree.getItems();
        Assert.assertTrue((boolean)items.isEmpty());
    }

    @Test
    public void testGetItems() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        List items = this.tree.getItems();
        Assert.assertThat((Object)items.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)items, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{this.item("A"), this.item("B"), this.item("C")}));
    }

    @Test
    public void testGetAllItems_noItems() {
        this.removeTreeItems((Tree)this.tree.getSWTWidget());
        List items = this.tree.getAllItems();
        Assert.assertTrue((boolean)items.isEmpty());
    }

    @Test
    public void testGetAllItems() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        List items = this.tree.getAllItems();
        Assert.assertThat((Object)items.size(), (Matcher)CoreMatchers.is((Object)7));
        Assert.assertThat((Object)items, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{this.item("A"), this.item("AA"), this.item("AAA"), this.item("AAB"), this.item("B"), this.item("BB"), this.item("C")}));
    }

    private TypeSafeMatcher<TreeItem> item(final String text) {
        return new TypeSafeMatcher<TreeItem>(){

            public void describeTo(Description description) {
            }

            protected boolean matchesSafely(TreeItem item) {
                return item.getText().equals(text);
            }
        };
    }
}

