/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.wizard;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.TableHasRows;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;

public class MavenProjectWizardArchetypePage
extends WizardPage {
    public MavenProjectWizardArchetypePage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public MavenProjectWizardArchetypePage selectArchetype(String groupId, String artifactId, String version) {
        DefaultTable t = new DefaultTable((ReferencedComposite)this);
        int groupColumn = t.getHeaderIndex("Group Id");
        int artColumn = t.getHeaderIndex("Artifact Id");
        int verColumn = t.getHeaderIndex("Version");
        boolean artifactFound = false;
        for (TableItem ti : t.getItems()) {
            if (groupId != null && !ti.getText(groupColumn).equals(groupId) || artifactId != null && !ti.getText(artColumn).equals(artifactId) || version != null && !ti.getText(verColumn).equals(version)) continue;
            ti.select();
            artifactFound = true;
            break;
        }
        if (!artifactFound) {
            throw new EclipseLayerException("Unable to find archetype with GAV: " + groupId + "," + artifactId + "," + version);
        }
        return this;
    }

    public MavenProjectWizardArchetypePage selectArchetypeCatalog(String catalog) {
        new DefaultCombo((ReferencedComposite)this, 0, new Matcher[0]).setSelection(catalog);
        new GroupWait(TimePeriod.VERY_LONG, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new JobIsRunning()), WaitProvider.waitUntil((WaitCondition)new TableHasRows((Table)new DefaultTable((ReferencedComposite)this)))});
        return this;
    }

    public String getArchetypeCatalog() {
        return new DefaultCombo((ReferencedComposite)this, 0, new Matcher[0]).getText();
    }

    public MavenProjectWizardArchetypePage toggleShowLatestArchetypeVersion(boolean toggle) {
        CheckBox box = new CheckBox((ReferencedComposite)this, new Matcher[]{new WithTextMatcher("&Show the last version of Archetype only")});
        box.toggle(false);
        return this;
    }

    public MavenProjectWizardArchetypePage setFilterText(String text) {
        DefaultText filter = new DefaultText(0, new Matcher[0]);
        filter.setText(text);
        return this;
    }
}

