/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.browser.BrowserEditor;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.browser.InternalBrowserRequirement;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@InternalBrowserRequirement.UseInternalBrowser
@RunWith(value=RedDeerSuite.class)
public class BrowserEditorTitleTest {
    private static final String BROWSER_TITLE = "[test-new] Test Title:.+";

    @Before
    public void openBrowser() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(38, null, BrowserEditorTitleTest.BROWSER_TITLE, "b").openURL(new URL("http://www.redhat.com"));
                }
                catch (PartInitException pie) {
                    throw new EclipseLayerException("Unable to create browser editor", (Throwable)pie);
                }
                catch (MalformedURLException mue) {
                    throw new EclipseLayerException("URL opening in browser is malformed", (Throwable)mue);
                }
            }
        });
    }

    @Test
    public void testEditor() {
        new DefaultEditor(BROWSER_TITLE);
        Assert.assertEquals((Object)"b", (Object)new BrowserEditor(BROWSER_TITLE).getTitleToolTip());
    }
}

