/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.toolbar;

import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.core.matcher.WithTooltipTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.clabel.DefaultCLabel;
import org.eclipse.reddeer.swt.impl.label.DefaultLabel;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolBar;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.tools.reddeer.swt.test.model.TestModel;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultToolBarTest {
    @Test
    public void testDefaultToolBar() {
        this.openPreferences();
        DefaultToolBar t = new DefaultToolBar();
        Assert.assertNotNull((Object)t);
        this.closePreferences();
    }

    @Test
    public void workbenchToolBarTest() {
        DefaultToolItem i = new DefaultToolItem((ReferencedComposite)new WorkbenchShell(), "RedDeer SWT WorkbenchToolItem");
        i.click();
        Assert.assertTrue((String)"ToolItem should be clicked", (boolean)TestModel.getClickedAndReset());
    }

    @Test
    public void workbenchToolBarRegexTest() {
        WithTooltipTextMatcher matcher = new WithTooltipTextMatcher((Matcher)new RegexMatcher("RedDeer SWT Workbench.*"));
        DefaultToolItem i = new DefaultToolItem((ReferencedComposite)new WorkbenchShell(), (Matcher)matcher);
        i.click();
        Assert.assertTrue((String)"ToolItem should be clicked", (boolean)TestModel.getClickedAndReset());
    }

    @Test
    public void testToolItemInShellToolBarFound() {
        this.openPreferences();
        DefaultToolItem ti = new DefaultToolItem();
        Assert.assertNotNull((Object)ti);
        this.closePreferences();
    }

    @Test
    public void testToolItemInShellToolBarClicked() {
        this.openPreferences();
        Assert.assertThat((Object)new DefaultCLabel().getText(), (Matcher)Is.is((Object)"General"));
        ((TreeItem)new DefaultTree().getItems().get(1)).select();
        Assert.assertThat((Object)new DefaultLabel().getText(), (Matcher)IsNot.not((Object)"General"));
        DefaultToolItem ti = new DefaultToolItem();
        ti.click();
        Assert.assertThat((Object)new DefaultCLabel().getText(), (Matcher)Is.is((Object)"General"));
        this.closePreferences();
    }

    @Test
    public void testToolItemInShellToolBarRegexClicked() {
        this.openPreferences();
        ((TreeItem)new DefaultTree().getItems().get(1)).select();
        DefaultToolItem ti = new DefaultToolItem((Matcher)new WithTooltipTextMatcher((Matcher)new RegexMatcher(".*ack.*")));
        Assert.assertNotNull((Object)ti);
        this.closePreferences();
    }

    private void openPreferences() {
        WorkbenchPreferenceDialog wd = new WorkbenchPreferenceDialog();
        wd.open();
        DefaultTreeItem item = new DefaultTreeItem(new String[]{"General"});
        item.select();
    }

    private void closePreferences() {
        ((TreeItem)new DefaultTree().getItems().get(0)).select();
        new PushButton("Cancel").click();
    }
}

