/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ToolBarRule
extends AbstractSimpleRedDeerRule {
    private String toolTipText;
    public static final int WORKBENCH = 1;
    public static final int VIEW = 2;
    public static final int SHELL = 3;
    private int type;

    public boolean appliesTo(Event event) {
        return event.widget instanceof ToolItem && event.type == 13;
    }

    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.toolTipText = ((ToolItem)event.widget).getToolTipText();
        Shell s = WidgetUtils.getShell((Control)((ToolItem)event.widget).getParent());
        if (s != null) {
            this.setShellTitle(s.getText());
        }
        CTabItem v = RedDeerUtils.getView((Control)((ToolItem)event.widget).getParent());
        Shell workbench = RedDeerUtils.getWorkbench();
        if (v != null) {
            this.setViewTitle(v.getText());
        }
        this.type = this.getViewTitle() != null ? 2 : (workbench != null && this.getShellTitle() != workbench.getText() ? 3 : 1);
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (this.type == 1) {
            builder.append("new WorkbenchToolItem(");
        } else if (this.type == 2) {
            builder.append("new ViewToolItem(");
        } else if (this.type == 3) {
            builder.append("new ShellToolItem(");
        }
        builder.append("\"" + this.toolTipText + "\").click()");
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.type == 1) {
            toReturn.add("org.eclipse.reddeer.swt.impl.toolbar.WorkbenchToolItem");
        } else if (this.type == 2) {
            toReturn.add("org.eclipse.reddeer.swt.impl.toolbar.ViewToolItem");
        } else if (this.type == 3) {
            toReturn.add("org.eclipse.reddeer.swt.impl.toolbar.ShellToolItem");
        }
        return toReturn;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

