/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.expandbar;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.api.ExpandItem;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.expandbar.DefaultExpandBar;
import org.eclipse.reddeer.swt.impl.expandbar.DefaultExpandItem;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExpandBarTest
extends SWTLayerTestCase {
    private static final String EXPAND_ITEM_LABEL_PREFIX = "Expand Item: ";
    private static final String TEXT_LABEL_PREFIX = "Text: ";
    private static final String TEXT_VALUE_PREFIX = "EB:2 TX: ";
    private static final int EXPAND_BAR_0_NUM_ITEMS = 3;
    private static final int EXPAND_BAR_1_NUM_ITEMS = 5;

    @Override
    protected void createControls(Shell shell) {
        org.eclipse.swt.widgets.ExpandItem item;
        Label label;
        GridLayout layout;
        Composite composite;
        ExpandBar bar = new ExpandBar((Composite)shell, 512);
        int itemIndex = 0;
        while (itemIndex < 3) {
            composite = new Composite((Composite)bar, 0);
            layout = new GridLayout(2, true);
            composite.setLayout((Layout)layout);
            int rowIndex = 0;
            while (rowIndex < 5) {
                label = new Label(composite, 8);
                label.setText(TEXT_LABEL_PREFIX + itemIndex + rowIndex);
                new Text(composite, 2048);
                ++rowIndex;
            }
            item = new org.eclipse.swt.widgets.ExpandItem(bar, 0, 0);
            item.setText(EXPAND_ITEM_LABEL_PREFIX + itemIndex);
            item.setHeight(composite.computeSize((int)-1, (int)-1).y);
            item.setControl((Control)composite);
            ++itemIndex;
        }
        bar = new ExpandBar((Composite)shell, 512);
        itemIndex = 0;
        while (itemIndex < 5) {
            composite = new Composite((Composite)bar, 0);
            layout = new GridLayout(2, true);
            composite.setLayout((Layout)layout);
            int rowIndex = 0;
            while (rowIndex < 5) {
                label = new Label(composite, 8);
                label.setText(TEXT_LABEL_PREFIX + itemIndex + rowIndex);
                Text text = new Text(composite, 2048);
                text.setText(TEXT_VALUE_PREFIX + itemIndex + rowIndex);
                ++rowIndex;
            }
            item = new org.eclipse.swt.widgets.ExpandItem(bar, 0, 0);
            item.setText(EXPAND_ITEM_LABEL_PREFIX + itemIndex);
            item.setHeight(composite.computeSize((int)-1, (int)-1).y);
            item.setControl((Control)composite);
            ++itemIndex;
        }
    }

    @Test
    public void findByIndexAndExpand() {
        DefaultExpandItem expandBarItem = new DefaultExpandItem(1, 0);
        expandBarItem.expand();
        Assert.assertTrue((String)("Expand bar item " + expandBarItem.getText() + " is not expanded"), (boolean)expandBarItem.isExpanded());
        String textOfTextWidget = new DefaultText(1, new Matcher[0]).getText();
        Assert.assertTrue((String)"Incorrect Text Wiget was found", (boolean)textOfTextWidget.equals("EB:2 TX: 01"));
    }

    @Test
    public void findByNameAndExpand() {
        DefaultExpandItem expandBarItem = new DefaultExpandItem(1, "Expand Item: 1");
        expandBarItem.expand();
        Assert.assertTrue((String)("Expand bar item " + expandBarItem.getText() + " is not expanded"), (boolean)expandBarItem.isExpanded());
        String textOfTextWidget = new DefaultText(2, new Matcher[0]).getText();
        Assert.assertTrue((String)"Incorrect Text Wiget was found", (boolean)textOfTextWidget.equals("EB:2 TX: 12"));
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByIndex() {
        new DefaultExpandItem(3, 1);
    }

    @Test(expected=SWTLayerException.class)
    public void findNonExistingByLabel() {
        new DefaultExpandItem("NON_EXISTING_#$");
    }

    @Test
    public void expandAll() {
        DefaultExpandBar expandBar = new DefaultExpandBar();
        expandBar.expandAll();
        for (ExpandItem expandBarItem : expandBar.getItems()) {
            Assert.assertTrue((String)("Expand Bar Item " + expandBarItem.getText() + " is not expanded"), (boolean)expandBarItem.isExpanded());
        }
    }

    @Test
    public void collapseAll() {
        DefaultExpandBar expandBar = new DefaultExpandBar(1, new Matcher[0]);
        new DefaultExpandItem(1, 0).expand();
        new DefaultExpandItem(1, 2).expand();
        new DefaultExpandItem(1, 4).expand();
        expandBar.collapseAll();
        for (ExpandItem expandBarItem : expandBar.getItems()) {
            Assert.assertTrue((String)("Expand Bar Item " + expandBarItem.getText() + " is not collapsed"), (!expandBarItem.isExpanded() ? 1 : 0) != 0);
        }
    }

    @Test
    public void getItemsCount() {
        int numItems = new DefaultExpandBar().getItemsCount();
        Assert.assertTrue((String)("First expand bar has to have 3 but has " + numItems), (numItems == 3 ? 1 : 0) != 0);
        numItems = new DefaultExpandBar(1, new Matcher[0]).getItemsCount();
        Assert.assertTrue((String)("First expand bar has to have 5 but has " + numItems), (numItems == 5 ? 1 : 0) != 0);
    }

    @Test
    public void getBarItems() {
        Assert.assertEquals((long)3L, (long)new DefaultExpandBar().getItems().size());
    }
}

